import { C as Class, P as PlainObject, a as Primitive } from './types-ANR2ETqw.js';

declare const isArray: (arg: any) => arg is any[];
declare const isArrayOf: (target: unknown[], predicate: (v: unknown) => boolean) => boolean;
declare const isAsyncGeneratorFunction: (value: unknown) => value is (...arguments_: any[]) => Promise<unknown>;
declare const isAsyncFunction: (value: unknown) => value is Function;
declare const isBigInt: (value: unknown) => value is bigint;
declare const isBoolean: (value: unknown) => value is boolean;
declare const isDate: (value: unknown) => value is Date;
declare const isDefined: (value: unknown) => boolean;
declare const isDomElement: (value: unknown) => value is HTMLElement;
declare const isEmpty: (value: unknown) => boolean;
declare const isError: (value: unknown) => value is Error;
declare const isFunction: (value: unknown) => value is Function;
declare const isGenerator: (value: unknown) => value is Generator<unknown, any, unknown>;
declare const isGeneratorFunction: (value: unknown) => value is GeneratorFunction;
declare const isInstanceOf: <T>(instance: unknown, class_: Class<T>) => instance is T;
declare const isIterable: (value: unknown) => value is IterableIterator<unknown>;
declare const isMap: (value: unknown) => value is Map<unknown, unknown>;
declare const isNan: (value: unknown) => boolean;
declare const isNull: (value: unknown) => value is null;
declare const isNullOrUndefined: (value: unknown) => value is null | undefined;
declare const isNumber: (value: unknown) => value is number;
declare const isNumericString: (value: unknown) => value is string;
declare const isObject: (value: unknown) => value is object;
declare const isOneOf: (target: unknown[], value: any) => boolean;
declare const isPlainFunction: (value: unknown) => value is Function;
declare const isPlainObject: (value: unknown) => value is PlainObject;
declare const isPrimitive: (value: unknown) => value is Primitive;
declare const isPromise: (value: unknown) => value is Promise<unknown>;
declare const isPropertyOf: (target: PlainObject, key: string, predicate?: ((v: unknown) => boolean) | undefined) => boolean;
declare const isRegexp: (value: unknown) => value is RegExp;
declare const isSet: (value: unknown) => value is Set<PlainObject>;
declare const isString: (value: unknown) => value is string;
declare const isSymbol: (value: unknown) => value is symbol;
declare const isUndefined: (value: unknown) => value is undefined;
declare const isWeakMap: (value: unknown) => value is WeakMap<PlainObject, unknown>;
declare const isWeakSet: (value: unknown) => value is WeakSet<PlainObject>;

export { isArray, isArrayOf, isAsyncFunction, isAsyncGeneratorFunction, isBigInt, isBoolean, isDate, isDefined, isDomElement, isEmpty, isError, isFunction, isGenerator, isGeneratorFunction, isInstanceOf, isIterable, isMap, isNan, isNull, isNullOrUndefined, isNumber, isNumericString, isObject, isOneOf, isPlainFunction, isPlainObject, isPrimitive, isPromise, isPropertyOf, isRegexp, isSet, isString, isSymbol, isUndefined, isWeakMap, isWeakSet };
