import * as internal from "./internal/channel/mergeState.js";
/**
 * @since 2.0.0
 * @category symbols
 */
export const MergeStateTypeId = internal.MergeStateTypeId;
/**
 * @since 2.0.0
 * @category constructors
 */
export const BothRunning = internal.BothRunning;
/**
 * @since 2.0.0
 * @category constructors
 */
export const LeftDone = internal.LeftDone;
/**
 * @since 2.0.0
 * @category constructors
 */
export const RightDone = internal.RightDone;
/**
 * Returns `true` if the specified value is a `MergeState`, `false` otherwise.
 *
 * @since 2.0.0
 * @category refinements
 */
export const isMergeState = internal.isMergeState;
/**
 * Returns `true` if the specified `MergeState` is a `BothRunning`, `false`
 * otherwise.
 *
 * @since 2.0.0
 * @category refinements
 */
export const isBothRunning = internal.isBothRunning;
/**
 * Returns `true` if the specified `MergeState` is a `LeftDone`, `false`
 * otherwise.
 *
 * @since 2.0.0
 * @category refinements
 */
export const isLeftDone = internal.isLeftDone;
/**
 * Returns `true` if the specified `MergeState` is a `RightDone`, `false`
 * otherwise.
 *
 * @since 2.0.0
 * @category refinements
 */
export const isRightDone = internal.isRightDone;
/**
 * @since 2.0.0
 * @category folding
 */
export const match = internal.match;
//# sourceMappingURL=MergeState.js.map