import { DeleteRequestParams, GetRequestParams, PostRequestParams, PutRequestParams, RequestParams, Session, ShopifyRestResources } from '@shopify/shopify-api';
import type { AdminClientOptions } from './types';
export type RestClientWithResources<Resources extends ShopifyRestResources> = RemixRestClient & {
    resources: Resources;
};
export declare function restClientFactory<Resources extends ShopifyRestResources = ShopifyRestResources>({ params, handleClientError, session, }: AdminClientOptions): RestClientWithResources<Resources>;
declare class RemixRestClient {
    session: Session;
    private params;
    private handleClientError;
    constructor({ params, session, handleClientError }: AdminClientOptions);
    /**
     * Performs a GET request on the given path.
     *
     * @deprecated In a future major release REST will be removed from this package. Please see [all-in on graphql](https://www.shopify.com/ca/partners/blog/all-in-on-graphql).
     */
    get(params: GetRequestParams): Promise<Response>;
    /**
     * Performs a POST request on the given path.
     *
     * @deprecated In a future major release REST will be removed from this package. Please see [all-in on graphql](https://www.shopify.com/ca/partners/blog/all-in-on-graphql).
     */
    post(params: PostRequestParams): Promise<Response>;
    /**
     * Performs a PUT request on the given path.
     *
     * @deprecated In a future major release REST will be removed from this package. Please see [all-in on graphql](https://www.shopify.com/ca/partners/blog/all-in-on-graphql).
     */
    put(params: PutRequestParams): Promise<Response>;
    /**
     * Performs a DELETE request on the given path.
     *
     * @deprecated In a future major release REST will be removed from this package. Please see [all-in on graphql](https://www.shopify.com/ca/partners/blog/all-in-on-graphql).
     */
    delete(params: DeleteRequestParams): Promise<Response>;
    protected makeRequest(params: RequestParams): Promise<Response>;
}
export {};
//# sourceMappingURL=rest.d.ts.map