import { Session, Shopify, ShopifyRestResources } from '@shopify/shopify-api';
import { AppConfig, AppConfigArg } from '../../../config-types';
import { BasicParams } from '../../../types';
import { HandleAdminClientError } from '../../../clients';
import type { ApiConfigWithFutureFlags, ApiFutureFlags } from '../../../future/flags';
import { AuthorizationStrategy, SessionContext } from './types';
export declare class TokenExchangeStrategy<Config extends AppConfigArg> implements AuthorizationStrategy {
    protected api: Shopify<ApiConfigWithFutureFlags<Config['future']>, ShopifyRestResources, ApiFutureFlags<Config['future']>>;
    protected config: AppConfig;
    protected logger: Shopify['logger'];
    constructor({ api, config, logger }: BasicParams<Config['future']>);
    respondToOAuthRequests(_request: Request): Promise<void>;
    authenticate(request: Request, sessionContext: SessionContext): Promise<Session>;
    handleClientError(request: Request): HandleAdminClientError;
    private exchangeToken;
    private handleAfterAuthHook;
}
//# sourceMappingURL=token-exchange.d.ts.map