import { graphqlClientFactory } from './graphql.mjs';
import { restClientFactory } from './rest.mjs';

function adminClientFactory({ params, handleClientError, session, }) {
    if (params.config.future.removeRest) {
        return {
            graphql: graphqlClientFactory({ params, session, handleClientError }),
        };
    }
    return {
        rest: restClientFactory({
            params,
            session,
            handleClientError,
        }),
        graphql: graphqlClientFactory({ params, session, handleClientError }),
    };
}

export { adminClientFactory };
//# sourceMappingURL=factory.mjs.map
