import { appBridgeUrl } from '../../helpers/app-bridge-url.mjs';
import { addDocumentResponseHeaders } from '../../helpers/add-response-headers.mjs';
import { sanitizeRedirectUrl } from './validate-redirect-url.mjs';

function renderAppBridge({ config }, request, redirectTo) {
    let redirectToScript = '';
    if (redirectTo) {
        const destination = sanitizeRedirectUrl(config.appUrl, redirectTo.url);
        const target = redirectTo.target ?? '_top';
        redirectToScript = `<script>window.open(${JSON.stringify(destination.toString())}, ${JSON.stringify(target)})</script>`;
    }
    const responseHeaders = new Headers({
        'content-type': 'text/html;charset=utf-8',
    });
    addDocumentResponseHeaders(responseHeaders, config.isEmbeddedApp, new URL(request.url).searchParams.get('shop'));
    throw new Response(`
      <script data-api-key="${config.apiKey}" src="${appBridgeUrl()}"></script>
      ${redirectToScript}
    `, { headers: responseHeaders });
}

export { renderAppBridge };
//# sourceMappingURL=render-app-bridge.mjs.map
