import { redirect } from '@remix-run/server-runtime';
import { redirectWithAppBridgeHeaders } from './redirect-with-app-bridge-headers.mjs';

async function redirectToInstallPage(params, shop, optionalScopes = []) {
    const installUrl = buildInstallUrl(params, shop, optionalScopes);
    if (params.config.isEmbeddedApp) {
        throw redirectWithAppBridgeHeaders(installUrl);
    }
    else {
        throw redirect(installUrl);
    }
}
function buildInstallUrl(params, shop, optionalScopes = []) {
    const baseInstallUrl = buildBaseInstallUrl(params, shop);
    baseInstallUrl.search = buildParamsInstallUrl(params, optionalScopes).toString();
    return baseInstallUrl.href;
}
function buildBaseInstallUrl({ api }, shop) {
    const cleanShop = api.utils.sanitizeShop(shop, true);
    return new URL(`https://${cleanShop}/admin/oauth/install`);
}
function buildParamsInstallUrl({ config }, optionalScopes = []) {
    const optionalScopesParam = optionalScopes && optionalScopes.length > 0
        ? { optional_scopes: optionalScopes.join(',') }
        : undefined;
    const query = {
        client_id: config.apiKey,
        scope: config.scopes?.toString() || '',
        ...optionalScopesParam,
    };
    return new URLSearchParams(query);
}

export { redirectToInstallPage };
//# sourceMappingURL=redirect-to-install-page.mjs.map
