'use strict';

require('@shopify/shopify-api/adapters/web-api');
var runtime = require('@shopify/shopify-api/runtime');
var shopifyApi = require('@shopify/shopify-api');
var types = require('./types.js');
var index = require('./boundary/index.js');
var shopifyApp = require('./shopify-app.js');
var errors = require('./errors.js');

runtime.setAbstractRuntimeString(() => {
    return `Remix`;
});

Object.defineProperty(exports, "ApiVersion", {
    enumerable: true,
    get: function () { return shopifyApi.ApiVersion; }
});
Object.defineProperty(exports, "BillingInterval", {
    enumerable: true,
    get: function () { return shopifyApi.BillingInterval; }
});
Object.defineProperty(exports, "BillingReplacementBehavior", {
    enumerable: true,
    get: function () { return shopifyApi.BillingReplacementBehavior; }
});
Object.defineProperty(exports, "DeliveryMethod", {
    enumerable: true,
    get: function () { return shopifyApi.DeliveryMethod; }
});
Object.defineProperty(exports, "LATEST_API_VERSION", {
    enumerable: true,
    get: function () { return shopifyApi.LATEST_API_VERSION; }
});
Object.defineProperty(exports, "LogSeverity", {
    enumerable: true,
    get: function () { return shopifyApi.LogSeverity; }
});
Object.defineProperty(exports, "RELEASE_CANDIDATE_API_VERSION", {
    enumerable: true,
    get: function () { return shopifyApi.RELEASE_CANDIDATE_API_VERSION; }
});
Object.defineProperty(exports, "Session", {
    enumerable: true,
    get: function () { return shopifyApi.Session; }
});
Object.defineProperty(exports, "AppDistribution", {
    enumerable: true,
    get: function () { return types.AppDistribution; }
});
Object.defineProperty(exports, "LoginErrorType", {
    enumerable: true,
    get: function () { return types.LoginErrorType; }
});
exports.boundary = index.boundary;
exports.shopifyApp = shopifyApp.shopifyApp;
exports.SessionNotFoundError = errors.SessionNotFoundError;
//# sourceMappingURL=index.js.map
