'use strict';

var authenticate$3 = require('./checkout/authenticate.js');
var authenticate = require('./appProxy/authenticate.js');
var authenticate$2 = require('./customer-account/authenticate.js');
var authenticate$1 = require('./pos/authenticate.js');

function authenticatePublicFactory(params) {
    const authenticateCheckout = authenticate$3.authenticateCheckoutFactory(params);
    const authenticateAppProxy = authenticate.authenticateAppProxyFactory(params);
    const authenticateCustomerAccount = authenticate$2.authenticateCustomerAccountFactory(params);
    const authenticatePOS = authenticate$1.authenticatePOSFactory(params);
    const context = {
        checkout: authenticateCheckout,
        appProxy: authenticateAppProxy,
        customerAccount: authenticateCustomerAccount,
        pos: authenticatePOS,
    };
    return context;
}

exports.authenticatePublicFactory = authenticatePublicFactory;
//# sourceMappingURL=factory.js.map
