'use strict';

var ensureCorsHeaders = require('../../helpers/ensure-cors-headers.js');
var validateSessionToken = require('../../helpers/validate-session-token.js');
var getSessionTokenHeader = require('../../helpers/get-session-token-header.js');
var rejectBotRequest = require('../../helpers/reject-bot-request.js');
var respondToOptionsRequest = require('../../helpers/respond-to-options-request.js');
require('@remix-run/server-runtime');
require('../../../types.js');
var getShopFromRequest = require('../../helpers/get-shop-from-request.js');

function authenticateExtensionFactory(params, requestType) {
    return async function authenticateExtension(request, options = {}) {
        const { logger } = params;
        const corsHeaders = options.corsHeaders ?? [];
        rejectBotRequest.respondToBotRequest(params, request);
        respondToOptionsRequest.respondToOptionsRequest(params, request, corsHeaders);
        const sessionTokenHeader = getSessionTokenHeader.getSessionTokenHeader(request);
        logger.info(`Authenticating ${requestType} request`, {
            shop: getShopFromRequest.getShopFromRequest(request),
        });
        if (!sessionTokenHeader) {
            logger.debug('Request did not contain a session token', {
                shop: getShopFromRequest.getShopFromRequest(request),
            });
            throw new Response(undefined, {
                status: 401,
                statusText: 'Unauthorized',
            });
        }
        return {
            sessionToken: await validateSessionToken.validateSessionToken(params, request, sessionTokenHeader, { checkAudience: false, retryRequest: false }),
            cors: ensureCorsHeaders.ensureCORSHeadersFactory(params, request, corsHeaders),
        };
    };
}

exports.authenticateExtensionFactory = authenticateExtensionFactory;
//# sourceMappingURL=authenticate.js.map
