'use strict';

var redirectToShopifyOrAppRoot = require('./redirect-to-shopify-or-app-root.js');

const ensureAppIsEmbeddedIfRequired = async (params, request) => {
    const { api, logger, config } = params;
    const url = new URL(request.url);
    const shop = url.searchParams.get('shop');
    if (api.config.isEmbeddedApp && url.searchParams.get('embedded') !== '1') {
        logger.debug('App is not embedded, redirecting to Shopify', { shop });
        await redirectToShopifyOrAppRoot.redirectToShopifyOrAppRoot(request, { api});
    }
};

exports.ensureAppIsEmbeddedIfRequired = ensureAppIsEmbeddedIfRequired;
//# sourceMappingURL=ensure-app-is-embedded-if-required.js.map
