import { JwtPayload } from '../lib';
interface TestJwt {
    token: string;
    payload: JwtPayload;
}
/**
 * Creates and signs a JWT token to use in faking authorization for testing.
 *
 * @param store The name of the store for which to create a valid JWT token.
 * @param apiKey The Client ID/API key for the store for which to create a valid JWT token.
 * @param apiSecretKey The API secret for the store for which to create a valid JWT token.
 * @param overrides Optional overrides for the JWT payload.
 * @returns {TestJwt} The JWT token and the JWT payload used to create the token.
 */
export declare function getJwt(store: string, apiKey: string, apiSecretKey: string, overrides?: Partial<JwtPayload>): TestJwt;
export {};
//# sourceMappingURL=get-jwt.d.ts.map