import { sanitizeHost, sanitizeShop } from './shop-validator.mjs';
import { validateHmac } from './hmac-validator.mjs';
import { versionPriorTo, versionCompatible } from './version-compatible.mjs';
import { legacyUrlToShopAdminUrl, shopAdminUrlToLegacyUrl } from './shop-admin-url-helper.mjs';

function shopifyUtils(config) {
    return {
        sanitizeShop: sanitizeShop(config),
        sanitizeHost: sanitizeHost(),
        validateHmac: validateHmac(config),
        versionCompatible: versionCompatible(config),
        versionPriorTo: versionPriorTo(config),
        shopAdminUrlToLegacyUrl,
        legacyUrlToShopAdminUrl,
    };
}

export { shopifyUtils };
//# sourceMappingURL=index.mjs.map
