import '../../runtime/crypto/crypto.mjs';
import '../../runtime/crypto/types.mjs';
import { canonicalizeHeaders } from '../../runtime/http/headers.mjs';

async function nodeConvertRequest(adapterArgs) {
    const req = adapterArgs.rawRequest;
    return {
        headers: canonicalizeHeaders({ ...req.headers }),
        method: req.method ?? 'GET',
        // Express.js overrides the url property, so we want to use originalUrl for it
        url: req.originalUrl || req.url,
    };
}
async function nodeConvertIncomingResponse(adapterArgs) {
    return {
        statusCode: adapterArgs.rawResponse.statusCode,
        statusText: adapterArgs.rawResponse.statusMessage,
        headers: canonicalizeHeaders(adapterArgs.rawResponse.getHeaders()),
    };
}
async function nodeConvertAndSendResponse(response, adapterArgs) {
    const res = adapterArgs.rawResponse;
    if (response.headers) {
        await nodeConvertAndSetHeaders(response.headers, adapterArgs);
    }
    if (response.body) {
        res.write(response.body);
    }
    res.statusCode = response.statusCode;
    res.statusMessage = response.statusText;
    res.end();
}
async function nodeConvertAndSetHeaders(headers, adapterArgs) {
    const res = adapterArgs.rawResponse;
    Object.entries(headers).forEach(([header, value]) => res.setHeader(header, value));
}
function nodeRuntimeString() {
    return `Node ${process.version}`;
}

export { nodeConvertAndSendResponse, nodeConvertAndSetHeaders, nodeConvertIncomingResponse, nodeConvertRequest, nodeRuntimeString };
//# sourceMappingURL=adapter.mjs.map
