'use strict';

const CLIENT = 'GraphQL Client';
const MIN_RETRIES = 0;
const MAX_RETRIES = 3;
const GQL_API_ERROR = "An error occurred while fetching from the API. Review 'graphQLErrors' for details.";
const UNEXPECTED_CONTENT_TYPE_ERROR = 'Response returned unexpected Content-Type:';
const NO_DATA_OR_ERRORS_ERROR = 'An unknown error has occurred. The API did not return a data object or any errors in its response.';
const CONTENT_TYPES = {
    json: 'application/json',
    multipart: 'multipart/mixed',
};
const SDK_VARIANT_HEADER = 'X-SDK-Variant';
const SDK_VERSION_HEADER = 'X-SDK-Version';
const DEFAULT_SDK_VARIANT = 'shopify-graphql-client';
// This is value is replaced with package.json version during rollup build process
const DEFAULT_CLIENT_VERSION = '1.4.1';
const RETRY_WAIT_TIME = 1000;
const RETRIABLE_STATUS_CODES = [429, 503];
const DEFER_OPERATION_REGEX = /@(defer)\b/i;
const NEWLINE_SEPARATOR = '\r\n';
const BOUNDARY_HEADER_REGEX = /boundary="?([^=";]+)"?/i;
const HEADER_SEPARATOR = NEWLINE_SEPARATOR + NEWLINE_SEPARATOR;

exports.BOUNDARY_HEADER_REGEX = BOUNDARY_HEADER_REGEX;
exports.CLIENT = CLIENT;
exports.CONTENT_TYPES = CONTENT_TYPES;
exports.DEFAULT_CLIENT_VERSION = DEFAULT_CLIENT_VERSION;
exports.DEFAULT_SDK_VARIANT = DEFAULT_SDK_VARIANT;
exports.DEFER_OPERATION_REGEX = DEFER_OPERATION_REGEX;
exports.GQL_API_ERROR = GQL_API_ERROR;
exports.HEADER_SEPARATOR = HEADER_SEPARATOR;
exports.MAX_RETRIES = MAX_RETRIES;
exports.MIN_RETRIES = MIN_RETRIES;
exports.NEWLINE_SEPARATOR = NEWLINE_SEPARATOR;
exports.NO_DATA_OR_ERRORS_ERROR = NO_DATA_OR_ERRORS_ERROR;
exports.RETRIABLE_STATUS_CODES = RETRIABLE_STATUS_CODES;
exports.RETRY_WAIT_TIME = RETRY_WAIT_TIME;
exports.SDK_VARIANT_HEADER = SDK_VARIANT_HEADER;
exports.SDK_VERSION_HEADER = SDK_VERSION_HEADER;
exports.UNEXPECTED_CONTENT_TYPE_ERROR = UNEXPECTED_CONTENT_TYPE_ERROR;
//# sourceMappingURL=constants.js.map
