import { ApiClientConfig, CustomFetchApi, ApiClientLogger, ApiClientLogContentTypes, ApiClient } from '@shopify/graphql-client';
export { AllOperations, ApiClientRequestOptions, ClientResponse, FetchResponseBody, HTTPResponseGraphQLDeprecationNotice, HTTPResponseLog, HTTPRetryLog, LogContent, ResponseWithType, ReturnData } from '@shopify/graphql-client';

type AdminApiClientLogContentTypes = ApiClientLogContentTypes;
type AdminApiClientConfig = ApiClientConfig & {
    accessToken: string;
    userAgentPrefix?: string;
};
type AdminApiClientOptions = Omit<AdminApiClientConfig, 'headers' | 'apiUrl'> & {
    customFetchApi?: CustomFetchApi;
    logger?: ApiClientLogger<AdminApiClientLogContentTypes>;
    isTesting?: boolean;
};

interface AdminQueries {
    [key: string]: {
        variables: any;
        return: any;
    };
    [key: number | symbol]: never;
}
interface AdminMutations {
    [key: string]: {
        variables: any;
        return: any;
    };
    [key: number | symbol]: never;
}
type AdminOperations = AdminQueries & AdminMutations;
type AdminApiClient = ApiClient<AdminApiClientConfig, AdminOperations>;

declare function createAdminApiClient({ storeDomain, apiVersion, accessToken, userAgentPrefix, retries, customFetchApi, logger, isTesting, }: AdminApiClientOptions): AdminApiClient;

type SearchParamField = string | number;
type SearchParamFields = SearchParamField | SearchParamField[] | Record<string, SearchParamField | SearchParamField[]>;
type SearchParams = Record<string, SearchParamFields>;
type HeaderOptions = Record<string, string | number | string[]>;
interface GetRequestOptions {
    headers?: HeaderOptions;
    data?: Record<string, any> | string;
    searchParams?: SearchParams;
    retries?: number;
    apiVersion?: string;
}
interface PostRequestOptions extends GetRequestOptions {
    data: Required<GetRequestOptions>['data'];
}
interface PutRequestOptions extends PostRequestOptions {
}
interface DeleteRequestOptions extends GetRequestOptions {
}
interface AdminRestApiClientOptions extends AdminApiClientOptions {
    scheme?: 'https' | 'http';
    defaultRetryTime?: number;
    formatPaths?: boolean;
}
interface AdminRestApiClient {
    get: (path: string, options?: GetRequestOptions) => ReturnType<CustomFetchApi>;
    put: (path: string, options?: PutRequestOptions) => ReturnType<CustomFetchApi>;
    post: (path: string, options?: PostRequestOptions) => ReturnType<CustomFetchApi>;
    delete: (path: string, options?: DeleteRequestOptions) => ReturnType<CustomFetchApi>;
}

declare function createAdminRestApiClient({ storeDomain, apiVersion, accessToken, userAgentPrefix, logger, customFetchApi, retries: clientRetries, scheme, defaultRetryTime, formatPaths, isTesting, }: AdminRestApiClientOptions): AdminRestApiClient;

export { createAdminApiClient, createAdminRestApiClient };
export type { AdminApiClient, AdminMutations, AdminOperations, AdminQueries, AdminRestApiClient, SearchParams };
