import { type UNSAFE_RouteConfigEntry as RouteConfigEntry } from "@remix-run/dev";
/**
 * Provides the absolute path to the app directory, for use within `routes.ts`.
 * This is designed to support resolving file system routes.
 */
export declare function getAppDirectory(): string;
declare const routeOptionKeys: readonly ["id", "index", "caseSensitive"];
type RouteOptions = Pick<RouteConfigEntry, typeof routeOptionKeys[number]>;
/**
 * Helper function for creating a route config entry, for use within
 * `routes.ts`.
 */
declare function route(path: string | null | undefined, file: string, children?: RouteConfigEntry[]): RouteConfigEntry;
declare function route(path: string | null | undefined, file: string, options: RouteOptions, children?: RouteConfigEntry[]): RouteConfigEntry;
declare const indexOptionKeys: readonly ["id"];
type IndexOptions = Pick<RouteConfigEntry, typeof indexOptionKeys[number]>;
/**
 * Helper function for creating a route config entry for an index route, for use
 * within `routes.ts`.
 */
declare function index(file: string, options?: IndexOptions): RouteConfigEntry;
declare const layoutOptionKeys: readonly ["id"];
type LayoutOptions = Pick<RouteConfigEntry, typeof layoutOptionKeys[number]>;
/**
 * Helper function for creating a route config entry for a layout route, for use
 * within `routes.ts`.
 */
declare function layout(file: string, children?: RouteConfigEntry[]): RouteConfigEntry;
declare function layout(file: string, options: LayoutOptions, children?: RouteConfigEntry[]): RouteConfigEntry;
/**
 * Helper function for adding a path prefix to a set of routes without needing
 * to introduce a parent route file, for use within `routes.ts`.
 */
declare function prefix(prefixPath: string, routes: RouteConfigEntry[]): RouteConfigEntry[];
declare const helpers: {
    route: typeof route;
    index: typeof index;
    layout: typeof layout;
    prefix: typeof prefix;
};
export { route, index, layout, prefix };
/**
 * Creates a set of route config helpers that resolve file paths relative to the
 * given directory, for use within `routes.ts`. This is designed to support
 * splitting route config into multiple files within different directories.
 */
export declare function relative(directory: string): typeof helpers;
