"use strict";
Object.defineProperty(exports, "__esModule", { value: true });
exports.validate = exports.plugin = void 0;
const path_1 = require("path");
const plugin_helpers_1 = require("@graphql-codegen/plugin-helpers");
const visitor_plugin_common_1 = require("@graphql-codegen/visitor-plugin-common");
const graphql_1 = require("graphql");
const plugin = async (schema, _documents, pluginConfig) => {
    const cleanSchema = pluginConfig.federation ? (0, plugin_helpers_1.removeFederation)(schema) : schema;
    const descriptions = (0, visitor_plugin_common_1.getConfigValue)(pluginConfig.descriptions, true);
    const directiveIsRepeatable = (0, visitor_plugin_common_1.getConfigValue)(pluginConfig.directiveIsRepeatable, true);
    const schemaDescription = (0, visitor_plugin_common_1.getConfigValue)(pluginConfig.schemaDescription, undefined);
    const specifiedByUrl = (0, visitor_plugin_common_1.getConfigValue)(pluginConfig.specifiedByUrl, undefined);
    const introspection = (0, graphql_1.introspectionFromSchema)(cleanSchema, {
        descriptions,
        directiveIsRepeatable,
        schemaDescription,
        specifiedByUrl,
    });
    return pluginConfig.minify ? JSON.stringify(introspection) : JSON.stringify(introspection, null, 2);
};
exports.plugin = plugin;
const validate = async (schema, documents, config, outputFile) => {
    if ((0, path_1.extname)(outputFile) !== '.json') {
        throw new Error(`Plugin "introspection" requires extension to be ".json"!`);
    }
};
exports.validate = validate;
