import {
  ApiVersion,
  AuthScopes,
  BillingInterval,
  BillingReplacementBehavior,
  DeliveryMethod,
  LATEST_API_VERSION,
  LogSeverity,
  RELEASE_CANDIDATE_API_VERSION,
  RequestedTokenType,
  Session,
  ShopifyHeader,
  WebhookValidationErrorReason,
  shopifyApi
} from "./chunk-J2AYTXOD.js";
import {
  AppDistribution,
  LoginErrorType,
  REAUTH_URL_HEADER,
  RETRY_INVALID_SESSION_HEADER,
  appBridgeUrl
} from "./chunk-WGNB5GYI.js";
import {
  CookieNotFound,
  FeatureDeprecatedError,
  GraphqlQueryError,
  HttpResponseError,
  InvalidHmacError,
  InvalidJwtError,
  InvalidOAuthError,
  ShopifyError,
  addHeader,
  flatHeaders,
  isbot,
  setAbstractConvertHeadersFunc,
  setAbstractConvertRequestFunc,
  setAbstractConvertResponseFunc,
  setAbstractFetchFunc,
  setAbstractRuntimeString
} from "./chunk-KCKNU53H.js";
import {
  init_esm,
  redirect2 as redirect
} from "./chunk-VRCZWMNO.js";
import {
  require_jsx_runtime
} from "./chunk-4UGQLU7J.js";
import "./chunk-KTP3BVTT.js";
import {
  __commonJS,
  __publicField,
  __toESM
} from "./chunk-VRMXEQCD.js";

// node_modules/semver/internal/constants.js
var require_constants = __commonJS({
  "node_modules/semver/internal/constants.js"(exports, module) {
    "use strict";
    var SEMVER_SPEC_VERSION = "2.0.0";
    var MAX_LENGTH = 256;
    var MAX_SAFE_INTEGER = Number.MAX_SAFE_INTEGER || /* istanbul ignore next */
    9007199254740991;
    var MAX_SAFE_COMPONENT_LENGTH = 16;
    var MAX_SAFE_BUILD_LENGTH = MAX_LENGTH - 6;
    var RELEASE_TYPES = [
      "major",
      "premajor",
      "minor",
      "preminor",
      "patch",
      "prepatch",
      "prerelease"
    ];
    module.exports = {
      MAX_LENGTH,
      MAX_SAFE_COMPONENT_LENGTH,
      MAX_SAFE_BUILD_LENGTH,
      MAX_SAFE_INTEGER,
      RELEASE_TYPES,
      SEMVER_SPEC_VERSION,
      FLAG_INCLUDE_PRERELEASE: 1,
      FLAG_LOOSE: 2
    };
  }
});

// node_modules/semver/internal/debug.js
var require_debug = __commonJS({
  "node_modules/semver/internal/debug.js"(exports, module) {
    "use strict";
    var debug = typeof process === "object" && process.env && process.env.NODE_DEBUG && /\bsemver\b/i.test(process.env.NODE_DEBUG) ? (...args) => console.error("SEMVER", ...args) : () => {
    };
    module.exports = debug;
  }
});

// node_modules/semver/internal/re.js
var require_re = __commonJS({
  "node_modules/semver/internal/re.js"(exports, module) {
    "use strict";
    var {
      MAX_SAFE_COMPONENT_LENGTH,
      MAX_SAFE_BUILD_LENGTH,
      MAX_LENGTH
    } = require_constants();
    var debug = require_debug();
    exports = module.exports = {};
    var re = exports.re = [];
    var safeRe = exports.safeRe = [];
    var src = exports.src = [];
    var safeSrc = exports.safeSrc = [];
    var t = exports.t = {};
    var R = 0;
    var LETTERDASHNUMBER = "[a-zA-Z0-9-]";
    var safeRegexReplacements = [
      ["\\s", 1],
      ["\\d", MAX_LENGTH],
      [LETTERDASHNUMBER, MAX_SAFE_BUILD_LENGTH]
    ];
    var makeSafeRegex = (value) => {
      for (const [token, max] of safeRegexReplacements) {
        value = value.split(`${token}*`).join(`${token}{0,${max}}`).split(`${token}+`).join(`${token}{1,${max}}`);
      }
      return value;
    };
    var createToken = (name, value, isGlobal) => {
      const safe = makeSafeRegex(value);
      const index = R++;
      debug(name, index, value);
      t[name] = index;
      src[index] = value;
      safeSrc[index] = safe;
      re[index] = new RegExp(value, isGlobal ? "g" : void 0);
      safeRe[index] = new RegExp(safe, isGlobal ? "g" : void 0);
    };
    createToken("NUMERICIDENTIFIER", "0|[1-9]\\d*");
    createToken("NUMERICIDENTIFIERLOOSE", "\\d+");
    createToken("NONNUMERICIDENTIFIER", `\\d*[a-zA-Z-]${LETTERDASHNUMBER}*`);
    createToken("MAINVERSION", `(${src[t.NUMERICIDENTIFIER]})\\.(${src[t.NUMERICIDENTIFIER]})\\.(${src[t.NUMERICIDENTIFIER]})`);
    createToken("MAINVERSIONLOOSE", `(${src[t.NUMERICIDENTIFIERLOOSE]})\\.(${src[t.NUMERICIDENTIFIERLOOSE]})\\.(${src[t.NUMERICIDENTIFIERLOOSE]})`);
    createToken("PRERELEASEIDENTIFIER", `(?:${src[t.NONNUMERICIDENTIFIER]}|${src[t.NUMERICIDENTIFIER]})`);
    createToken("PRERELEASEIDENTIFIERLOOSE", `(?:${src[t.NONNUMERICIDENTIFIER]}|${src[t.NUMERICIDENTIFIERLOOSE]})`);
    createToken("PRERELEASE", `(?:-(${src[t.PRERELEASEIDENTIFIER]}(?:\\.${src[t.PRERELEASEIDENTIFIER]})*))`);
    createToken("PRERELEASELOOSE", `(?:-?(${src[t.PRERELEASEIDENTIFIERLOOSE]}(?:\\.${src[t.PRERELEASEIDENTIFIERLOOSE]})*))`);
    createToken("BUILDIDENTIFIER", `${LETTERDASHNUMBER}+`);
    createToken("BUILD", `(?:\\+(${src[t.BUILDIDENTIFIER]}(?:\\.${src[t.BUILDIDENTIFIER]})*))`);
    createToken("FULLPLAIN", `v?${src[t.MAINVERSION]}${src[t.PRERELEASE]}?${src[t.BUILD]}?`);
    createToken("FULL", `^${src[t.FULLPLAIN]}$`);
    createToken("LOOSEPLAIN", `[v=\\s]*${src[t.MAINVERSIONLOOSE]}${src[t.PRERELEASELOOSE]}?${src[t.BUILD]}?`);
    createToken("LOOSE", `^${src[t.LOOSEPLAIN]}$`);
    createToken("GTLT", "((?:<|>)?=?)");
    createToken("XRANGEIDENTIFIERLOOSE", `${src[t.NUMERICIDENTIFIERLOOSE]}|x|X|\\*`);
    createToken("XRANGEIDENTIFIER", `${src[t.NUMERICIDENTIFIER]}|x|X|\\*`);
    createToken("XRANGEPLAIN", `[v=\\s]*(${src[t.XRANGEIDENTIFIER]})(?:\\.(${src[t.XRANGEIDENTIFIER]})(?:\\.(${src[t.XRANGEIDENTIFIER]})(?:${src[t.PRERELEASE]})?${src[t.BUILD]}?)?)?`);
    createToken("XRANGEPLAINLOOSE", `[v=\\s]*(${src[t.XRANGEIDENTIFIERLOOSE]})(?:\\.(${src[t.XRANGEIDENTIFIERLOOSE]})(?:\\.(${src[t.XRANGEIDENTIFIERLOOSE]})(?:${src[t.PRERELEASELOOSE]})?${src[t.BUILD]}?)?)?`);
    createToken("XRANGE", `^${src[t.GTLT]}\\s*${src[t.XRANGEPLAIN]}$`);
    createToken("XRANGELOOSE", `^${src[t.GTLT]}\\s*${src[t.XRANGEPLAINLOOSE]}$`);
    createToken("COERCEPLAIN", `${"(^|[^\\d])(\\d{1,"}${MAX_SAFE_COMPONENT_LENGTH}})(?:\\.(\\d{1,${MAX_SAFE_COMPONENT_LENGTH}}))?(?:\\.(\\d{1,${MAX_SAFE_COMPONENT_LENGTH}}))?`);
    createToken("COERCE", `${src[t.COERCEPLAIN]}(?:$|[^\\d])`);
    createToken("COERCEFULL", src[t.COERCEPLAIN] + `(?:${src[t.PRERELEASE]})?(?:${src[t.BUILD]})?(?:$|[^\\d])`);
    createToken("COERCERTL", src[t.COERCE], true);
    createToken("COERCERTLFULL", src[t.COERCEFULL], true);
    createToken("LONETILDE", "(?:~>?)");
    createToken("TILDETRIM", `(\\s*)${src[t.LONETILDE]}\\s+`, true);
    exports.tildeTrimReplace = "$1~";
    createToken("TILDE", `^${src[t.LONETILDE]}${src[t.XRANGEPLAIN]}$`);
    createToken("TILDELOOSE", `^${src[t.LONETILDE]}${src[t.XRANGEPLAINLOOSE]}$`);
    createToken("LONECARET", "(?:\\^)");
    createToken("CARETTRIM", `(\\s*)${src[t.LONECARET]}\\s+`, true);
    exports.caretTrimReplace = "$1^";
    createToken("CARET", `^${src[t.LONECARET]}${src[t.XRANGEPLAIN]}$`);
    createToken("CARETLOOSE", `^${src[t.LONECARET]}${src[t.XRANGEPLAINLOOSE]}$`);
    createToken("COMPARATORLOOSE", `^${src[t.GTLT]}\\s*(${src[t.LOOSEPLAIN]})$|^$`);
    createToken("COMPARATOR", `^${src[t.GTLT]}\\s*(${src[t.FULLPLAIN]})$|^$`);
    createToken("COMPARATORTRIM", `(\\s*)${src[t.GTLT]}\\s*(${src[t.LOOSEPLAIN]}|${src[t.XRANGEPLAIN]})`, true);
    exports.comparatorTrimReplace = "$1$2$3";
    createToken("HYPHENRANGE", `^\\s*(${src[t.XRANGEPLAIN]})\\s+-\\s+(${src[t.XRANGEPLAIN]})\\s*$`);
    createToken("HYPHENRANGELOOSE", `^\\s*(${src[t.XRANGEPLAINLOOSE]})\\s+-\\s+(${src[t.XRANGEPLAINLOOSE]})\\s*$`);
    createToken("STAR", "(<|>)?=?\\s*\\*");
    createToken("GTE0", "^\\s*>=\\s*0\\.0\\.0\\s*$");
    createToken("GTE0PRE", "^\\s*>=\\s*0\\.0\\.0-0\\s*$");
  }
});

// node_modules/semver/internal/parse-options.js
var require_parse_options = __commonJS({
  "node_modules/semver/internal/parse-options.js"(exports, module) {
    "use strict";
    var looseOption = Object.freeze({ loose: true });
    var emptyOpts = Object.freeze({});
    var parseOptions = (options) => {
      if (!options) {
        return emptyOpts;
      }
      if (typeof options !== "object") {
        return looseOption;
      }
      return options;
    };
    module.exports = parseOptions;
  }
});

// node_modules/semver/internal/identifiers.js
var require_identifiers = __commonJS({
  "node_modules/semver/internal/identifiers.js"(exports, module) {
    "use strict";
    var numeric = /^[0-9]+$/;
    var compareIdentifiers = (a, b) => {
      if (typeof a === "number" && typeof b === "number") {
        return a === b ? 0 : a < b ? -1 : 1;
      }
      const anum = numeric.test(a);
      const bnum = numeric.test(b);
      if (anum && bnum) {
        a = +a;
        b = +b;
      }
      return a === b ? 0 : anum && !bnum ? -1 : bnum && !anum ? 1 : a < b ? -1 : 1;
    };
    var rcompareIdentifiers = (a, b) => compareIdentifiers(b, a);
    module.exports = {
      compareIdentifiers,
      rcompareIdentifiers
    };
  }
});

// node_modules/semver/classes/semver.js
var require_semver = __commonJS({
  "node_modules/semver/classes/semver.js"(exports, module) {
    "use strict";
    var debug = require_debug();
    var { MAX_LENGTH, MAX_SAFE_INTEGER } = require_constants();
    var { safeRe: re, t } = require_re();
    var parseOptions = require_parse_options();
    var { compareIdentifiers } = require_identifiers();
    var SemVer = class _SemVer {
      constructor(version, options) {
        options = parseOptions(options);
        if (version instanceof _SemVer) {
          if (version.loose === !!options.loose && version.includePrerelease === !!options.includePrerelease) {
            return version;
          } else {
            version = version.version;
          }
        } else if (typeof version !== "string") {
          throw new TypeError(`Invalid version. Must be a string. Got type "${typeof version}".`);
        }
        if (version.length > MAX_LENGTH) {
          throw new TypeError(
            `version is longer than ${MAX_LENGTH} characters`
          );
        }
        debug("SemVer", version, options);
        this.options = options;
        this.loose = !!options.loose;
        this.includePrerelease = !!options.includePrerelease;
        const m = version.trim().match(options.loose ? re[t.LOOSE] : re[t.FULL]);
        if (!m) {
          throw new TypeError(`Invalid Version: ${version}`);
        }
        this.raw = version;
        this.major = +m[1];
        this.minor = +m[2];
        this.patch = +m[3];
        if (this.major > MAX_SAFE_INTEGER || this.major < 0) {
          throw new TypeError("Invalid major version");
        }
        if (this.minor > MAX_SAFE_INTEGER || this.minor < 0) {
          throw new TypeError("Invalid minor version");
        }
        if (this.patch > MAX_SAFE_INTEGER || this.patch < 0) {
          throw new TypeError("Invalid patch version");
        }
        if (!m[4]) {
          this.prerelease = [];
        } else {
          this.prerelease = m[4].split(".").map((id) => {
            if (/^[0-9]+$/.test(id)) {
              const num = +id;
              if (num >= 0 && num < MAX_SAFE_INTEGER) {
                return num;
              }
            }
            return id;
          });
        }
        this.build = m[5] ? m[5].split(".") : [];
        this.format();
      }
      format() {
        this.version = `${this.major}.${this.minor}.${this.patch}`;
        if (this.prerelease.length) {
          this.version += `-${this.prerelease.join(".")}`;
        }
        return this.version;
      }
      toString() {
        return this.version;
      }
      compare(other) {
        debug("SemVer.compare", this.version, this.options, other);
        if (!(other instanceof _SemVer)) {
          if (typeof other === "string" && other === this.version) {
            return 0;
          }
          other = new _SemVer(other, this.options);
        }
        if (other.version === this.version) {
          return 0;
        }
        return this.compareMain(other) || this.comparePre(other);
      }
      compareMain(other) {
        if (!(other instanceof _SemVer)) {
          other = new _SemVer(other, this.options);
        }
        if (this.major < other.major) {
          return -1;
        }
        if (this.major > other.major) {
          return 1;
        }
        if (this.minor < other.minor) {
          return -1;
        }
        if (this.minor > other.minor) {
          return 1;
        }
        if (this.patch < other.patch) {
          return -1;
        }
        if (this.patch > other.patch) {
          return 1;
        }
        return 0;
      }
      comparePre(other) {
        if (!(other instanceof _SemVer)) {
          other = new _SemVer(other, this.options);
        }
        if (this.prerelease.length && !other.prerelease.length) {
          return -1;
        } else if (!this.prerelease.length && other.prerelease.length) {
          return 1;
        } else if (!this.prerelease.length && !other.prerelease.length) {
          return 0;
        }
        let i = 0;
        do {
          const a = this.prerelease[i];
          const b = other.prerelease[i];
          debug("prerelease compare", i, a, b);
          if (a === void 0 && b === void 0) {
            return 0;
          } else if (b === void 0) {
            return 1;
          } else if (a === void 0) {
            return -1;
          } else if (a === b) {
            continue;
          } else {
            return compareIdentifiers(a, b);
          }
        } while (++i);
      }
      compareBuild(other) {
        if (!(other instanceof _SemVer)) {
          other = new _SemVer(other, this.options);
        }
        let i = 0;
        do {
          const a = this.build[i];
          const b = other.build[i];
          debug("build compare", i, a, b);
          if (a === void 0 && b === void 0) {
            return 0;
          } else if (b === void 0) {
            return 1;
          } else if (a === void 0) {
            return -1;
          } else if (a === b) {
            continue;
          } else {
            return compareIdentifiers(a, b);
          }
        } while (++i);
      }
      // preminor will bump the version up to the next minor release, and immediately
      // down to pre-release. premajor and prepatch work the same way.
      inc(release, identifier, identifierBase) {
        if (release.startsWith("pre")) {
          if (!identifier && identifierBase === false) {
            throw new Error("invalid increment argument: identifier is empty");
          }
          if (identifier) {
            const match = `-${identifier}`.match(this.options.loose ? re[t.PRERELEASELOOSE] : re[t.PRERELEASE]);
            if (!match || match[1] !== identifier) {
              throw new Error(`invalid identifier: ${identifier}`);
            }
          }
        }
        switch (release) {
          case "premajor":
            this.prerelease.length = 0;
            this.patch = 0;
            this.minor = 0;
            this.major++;
            this.inc("pre", identifier, identifierBase);
            break;
          case "preminor":
            this.prerelease.length = 0;
            this.patch = 0;
            this.minor++;
            this.inc("pre", identifier, identifierBase);
            break;
          case "prepatch":
            this.prerelease.length = 0;
            this.inc("patch", identifier, identifierBase);
            this.inc("pre", identifier, identifierBase);
            break;
          // If the input is a non-prerelease version, this acts the same as
          // prepatch.
          case "prerelease":
            if (this.prerelease.length === 0) {
              this.inc("patch", identifier, identifierBase);
            }
            this.inc("pre", identifier, identifierBase);
            break;
          case "release":
            if (this.prerelease.length === 0) {
              throw new Error(`version ${this.raw} is not a prerelease`);
            }
            this.prerelease.length = 0;
            break;
          case "major":
            if (this.minor !== 0 || this.patch !== 0 || this.prerelease.length === 0) {
              this.major++;
            }
            this.minor = 0;
            this.patch = 0;
            this.prerelease = [];
            break;
          case "minor":
            if (this.patch !== 0 || this.prerelease.length === 0) {
              this.minor++;
            }
            this.patch = 0;
            this.prerelease = [];
            break;
          case "patch":
            if (this.prerelease.length === 0) {
              this.patch++;
            }
            this.prerelease = [];
            break;
          // This probably shouldn't be used publicly.
          // 1.0.0 'pre' would become 1.0.0-0 which is the wrong direction.
          case "pre": {
            const base = Number(identifierBase) ? 1 : 0;
            if (this.prerelease.length === 0) {
              this.prerelease = [base];
            } else {
              let i = this.prerelease.length;
              while (--i >= 0) {
                if (typeof this.prerelease[i] === "number") {
                  this.prerelease[i]++;
                  i = -2;
                }
              }
              if (i === -1) {
                if (identifier === this.prerelease.join(".") && identifierBase === false) {
                  throw new Error("invalid increment argument: identifier already exists");
                }
                this.prerelease.push(base);
              }
            }
            if (identifier) {
              let prerelease = [identifier, base];
              if (identifierBase === false) {
                prerelease = [identifier];
              }
              if (compareIdentifiers(this.prerelease[0], identifier) === 0) {
                if (isNaN(this.prerelease[1])) {
                  this.prerelease = prerelease;
                }
              } else {
                this.prerelease = prerelease;
              }
            }
            break;
          }
          default:
            throw new Error(`invalid increment argument: ${release}`);
        }
        this.raw = this.format();
        if (this.build.length) {
          this.raw += `+${this.build.join(".")}`;
        }
        return this;
      }
    };
    module.exports = SemVer;
  }
});

// node_modules/semver/functions/parse.js
var require_parse = __commonJS({
  "node_modules/semver/functions/parse.js"(exports, module) {
    "use strict";
    var SemVer = require_semver();
    var parse = (version, options, throwErrors = false) => {
      if (version instanceof SemVer) {
        return version;
      }
      try {
        return new SemVer(version, options);
      } catch (er) {
        if (!throwErrors) {
          return null;
        }
        throw er;
      }
    };
    module.exports = parse;
  }
});

// node_modules/semver/functions/valid.js
var require_valid = __commonJS({
  "node_modules/semver/functions/valid.js"(exports, module) {
    "use strict";
    var parse = require_parse();
    var valid = (version, options) => {
      const v = parse(version, options);
      return v ? v.version : null;
    };
    module.exports = valid;
  }
});

// node_modules/semver/functions/clean.js
var require_clean = __commonJS({
  "node_modules/semver/functions/clean.js"(exports, module) {
    "use strict";
    var parse = require_parse();
    var clean = (version, options) => {
      const s = parse(version.trim().replace(/^[=v]+/, ""), options);
      return s ? s.version : null;
    };
    module.exports = clean;
  }
});

// node_modules/semver/functions/inc.js
var require_inc = __commonJS({
  "node_modules/semver/functions/inc.js"(exports, module) {
    "use strict";
    var SemVer = require_semver();
    var inc = (version, release, options, identifier, identifierBase) => {
      if (typeof options === "string") {
        identifierBase = identifier;
        identifier = options;
        options = void 0;
      }
      try {
        return new SemVer(
          version instanceof SemVer ? version.version : version,
          options
        ).inc(release, identifier, identifierBase).version;
      } catch (er) {
        return null;
      }
    };
    module.exports = inc;
  }
});

// node_modules/semver/functions/diff.js
var require_diff = __commonJS({
  "node_modules/semver/functions/diff.js"(exports, module) {
    "use strict";
    var parse = require_parse();
    var diff = (version1, version2) => {
      const v1 = parse(version1, null, true);
      const v2 = parse(version2, null, true);
      const comparison = v1.compare(v2);
      if (comparison === 0) {
        return null;
      }
      const v1Higher = comparison > 0;
      const highVersion = v1Higher ? v1 : v2;
      const lowVersion = v1Higher ? v2 : v1;
      const highHasPre = !!highVersion.prerelease.length;
      const lowHasPre = !!lowVersion.prerelease.length;
      if (lowHasPre && !highHasPre) {
        if (!lowVersion.patch && !lowVersion.minor) {
          return "major";
        }
        if (lowVersion.compareMain(highVersion) === 0) {
          if (lowVersion.minor && !lowVersion.patch) {
            return "minor";
          }
          return "patch";
        }
      }
      const prefix = highHasPre ? "pre" : "";
      if (v1.major !== v2.major) {
        return prefix + "major";
      }
      if (v1.minor !== v2.minor) {
        return prefix + "minor";
      }
      if (v1.patch !== v2.patch) {
        return prefix + "patch";
      }
      return "prerelease";
    };
    module.exports = diff;
  }
});

// node_modules/semver/functions/major.js
var require_major = __commonJS({
  "node_modules/semver/functions/major.js"(exports, module) {
    "use strict";
    var SemVer = require_semver();
    var major = (a, loose) => new SemVer(a, loose).major;
    module.exports = major;
  }
});

// node_modules/semver/functions/minor.js
var require_minor = __commonJS({
  "node_modules/semver/functions/minor.js"(exports, module) {
    "use strict";
    var SemVer = require_semver();
    var minor = (a, loose) => new SemVer(a, loose).minor;
    module.exports = minor;
  }
});

// node_modules/semver/functions/patch.js
var require_patch = __commonJS({
  "node_modules/semver/functions/patch.js"(exports, module) {
    "use strict";
    var SemVer = require_semver();
    var patch = (a, loose) => new SemVer(a, loose).patch;
    module.exports = patch;
  }
});

// node_modules/semver/functions/prerelease.js
var require_prerelease = __commonJS({
  "node_modules/semver/functions/prerelease.js"(exports, module) {
    "use strict";
    var parse = require_parse();
    var prerelease = (version, options) => {
      const parsed = parse(version, options);
      return parsed && parsed.prerelease.length ? parsed.prerelease : null;
    };
    module.exports = prerelease;
  }
});

// node_modules/semver/functions/compare.js
var require_compare = __commonJS({
  "node_modules/semver/functions/compare.js"(exports, module) {
    "use strict";
    var SemVer = require_semver();
    var compare = (a, b, loose) => new SemVer(a, loose).compare(new SemVer(b, loose));
    module.exports = compare;
  }
});

// node_modules/semver/functions/rcompare.js
var require_rcompare = __commonJS({
  "node_modules/semver/functions/rcompare.js"(exports, module) {
    "use strict";
    var compare = require_compare();
    var rcompare = (a, b, loose) => compare(b, a, loose);
    module.exports = rcompare;
  }
});

// node_modules/semver/functions/compare-loose.js
var require_compare_loose = __commonJS({
  "node_modules/semver/functions/compare-loose.js"(exports, module) {
    "use strict";
    var compare = require_compare();
    var compareLoose = (a, b) => compare(a, b, true);
    module.exports = compareLoose;
  }
});

// node_modules/semver/functions/compare-build.js
var require_compare_build = __commonJS({
  "node_modules/semver/functions/compare-build.js"(exports, module) {
    "use strict";
    var SemVer = require_semver();
    var compareBuild = (a, b, loose) => {
      const versionA = new SemVer(a, loose);
      const versionB = new SemVer(b, loose);
      return versionA.compare(versionB) || versionA.compareBuild(versionB);
    };
    module.exports = compareBuild;
  }
});

// node_modules/semver/functions/sort.js
var require_sort = __commonJS({
  "node_modules/semver/functions/sort.js"(exports, module) {
    "use strict";
    var compareBuild = require_compare_build();
    var sort = (list, loose) => list.sort((a, b) => compareBuild(a, b, loose));
    module.exports = sort;
  }
});

// node_modules/semver/functions/rsort.js
var require_rsort = __commonJS({
  "node_modules/semver/functions/rsort.js"(exports, module) {
    "use strict";
    var compareBuild = require_compare_build();
    var rsort = (list, loose) => list.sort((a, b) => compareBuild(b, a, loose));
    module.exports = rsort;
  }
});

// node_modules/semver/functions/gt.js
var require_gt = __commonJS({
  "node_modules/semver/functions/gt.js"(exports, module) {
    "use strict";
    var compare = require_compare();
    var gt = (a, b, loose) => compare(a, b, loose) > 0;
    module.exports = gt;
  }
});

// node_modules/semver/functions/lt.js
var require_lt = __commonJS({
  "node_modules/semver/functions/lt.js"(exports, module) {
    "use strict";
    var compare = require_compare();
    var lt = (a, b, loose) => compare(a, b, loose) < 0;
    module.exports = lt;
  }
});

// node_modules/semver/functions/eq.js
var require_eq = __commonJS({
  "node_modules/semver/functions/eq.js"(exports, module) {
    "use strict";
    var compare = require_compare();
    var eq = (a, b, loose) => compare(a, b, loose) === 0;
    module.exports = eq;
  }
});

// node_modules/semver/functions/neq.js
var require_neq = __commonJS({
  "node_modules/semver/functions/neq.js"(exports, module) {
    "use strict";
    var compare = require_compare();
    var neq = (a, b, loose) => compare(a, b, loose) !== 0;
    module.exports = neq;
  }
});

// node_modules/semver/functions/gte.js
var require_gte = __commonJS({
  "node_modules/semver/functions/gte.js"(exports, module) {
    "use strict";
    var compare = require_compare();
    var gte = (a, b, loose) => compare(a, b, loose) >= 0;
    module.exports = gte;
  }
});

// node_modules/semver/functions/lte.js
var require_lte = __commonJS({
  "node_modules/semver/functions/lte.js"(exports, module) {
    "use strict";
    var compare = require_compare();
    var lte = (a, b, loose) => compare(a, b, loose) <= 0;
    module.exports = lte;
  }
});

// node_modules/semver/functions/cmp.js
var require_cmp = __commonJS({
  "node_modules/semver/functions/cmp.js"(exports, module) {
    "use strict";
    var eq = require_eq();
    var neq = require_neq();
    var gt = require_gt();
    var gte = require_gte();
    var lt = require_lt();
    var lte = require_lte();
    var cmp = (a, op, b, loose) => {
      switch (op) {
        case "===":
          if (typeof a === "object") {
            a = a.version;
          }
          if (typeof b === "object") {
            b = b.version;
          }
          return a === b;
        case "!==":
          if (typeof a === "object") {
            a = a.version;
          }
          if (typeof b === "object") {
            b = b.version;
          }
          return a !== b;
        case "":
        case "=":
        case "==":
          return eq(a, b, loose);
        case "!=":
          return neq(a, b, loose);
        case ">":
          return gt(a, b, loose);
        case ">=":
          return gte(a, b, loose);
        case "<":
          return lt(a, b, loose);
        case "<=":
          return lte(a, b, loose);
        default:
          throw new TypeError(`Invalid operator: ${op}`);
      }
    };
    module.exports = cmp;
  }
});

// node_modules/semver/functions/coerce.js
var require_coerce = __commonJS({
  "node_modules/semver/functions/coerce.js"(exports, module) {
    "use strict";
    var SemVer = require_semver();
    var parse = require_parse();
    var { safeRe: re, t } = require_re();
    var coerce = (version, options) => {
      if (version instanceof SemVer) {
        return version;
      }
      if (typeof version === "number") {
        version = String(version);
      }
      if (typeof version !== "string") {
        return null;
      }
      options = options || {};
      let match = null;
      if (!options.rtl) {
        match = version.match(options.includePrerelease ? re[t.COERCEFULL] : re[t.COERCE]);
      } else {
        const coerceRtlRegex = options.includePrerelease ? re[t.COERCERTLFULL] : re[t.COERCERTL];
        let next;
        while ((next = coerceRtlRegex.exec(version)) && (!match || match.index + match[0].length !== version.length)) {
          if (!match || next.index + next[0].length !== match.index + match[0].length) {
            match = next;
          }
          coerceRtlRegex.lastIndex = next.index + next[1].length + next[2].length;
        }
        coerceRtlRegex.lastIndex = -1;
      }
      if (match === null) {
        return null;
      }
      const major = match[2];
      const minor = match[3] || "0";
      const patch = match[4] || "0";
      const prerelease = options.includePrerelease && match[5] ? `-${match[5]}` : "";
      const build = options.includePrerelease && match[6] ? `+${match[6]}` : "";
      return parse(`${major}.${minor}.${patch}${prerelease}${build}`, options);
    };
    module.exports = coerce;
  }
});

// node_modules/semver/internal/lrucache.js
var require_lrucache = __commonJS({
  "node_modules/semver/internal/lrucache.js"(exports, module) {
    "use strict";
    var LRUCache = class {
      constructor() {
        this.max = 1e3;
        this.map = /* @__PURE__ */ new Map();
      }
      get(key) {
        const value = this.map.get(key);
        if (value === void 0) {
          return void 0;
        } else {
          this.map.delete(key);
          this.map.set(key, value);
          return value;
        }
      }
      delete(key) {
        return this.map.delete(key);
      }
      set(key, value) {
        const deleted = this.delete(key);
        if (!deleted && value !== void 0) {
          if (this.map.size >= this.max) {
            const firstKey = this.map.keys().next().value;
            this.delete(firstKey);
          }
          this.map.set(key, value);
        }
        return this;
      }
    };
    module.exports = LRUCache;
  }
});

// node_modules/semver/classes/range.js
var require_range = __commonJS({
  "node_modules/semver/classes/range.js"(exports, module) {
    "use strict";
    var SPACE_CHARACTERS = /\s+/g;
    var Range = class _Range {
      constructor(range, options) {
        options = parseOptions(options);
        if (range instanceof _Range) {
          if (range.loose === !!options.loose && range.includePrerelease === !!options.includePrerelease) {
            return range;
          } else {
            return new _Range(range.raw, options);
          }
        }
        if (range instanceof Comparator) {
          this.raw = range.value;
          this.set = [[range]];
          this.formatted = void 0;
          return this;
        }
        this.options = options;
        this.loose = !!options.loose;
        this.includePrerelease = !!options.includePrerelease;
        this.raw = range.trim().replace(SPACE_CHARACTERS, " ");
        this.set = this.raw.split("||").map((r) => this.parseRange(r.trim())).filter((c) => c.length);
        if (!this.set.length) {
          throw new TypeError(`Invalid SemVer Range: ${this.raw}`);
        }
        if (this.set.length > 1) {
          const first = this.set[0];
          this.set = this.set.filter((c) => !isNullSet(c[0]));
          if (this.set.length === 0) {
            this.set = [first];
          } else if (this.set.length > 1) {
            for (const c of this.set) {
              if (c.length === 1 && isAny(c[0])) {
                this.set = [c];
                break;
              }
            }
          }
        }
        this.formatted = void 0;
      }
      get range() {
        if (this.formatted === void 0) {
          this.formatted = "";
          for (let i = 0; i < this.set.length; i++) {
            if (i > 0) {
              this.formatted += "||";
            }
            const comps = this.set[i];
            for (let k = 0; k < comps.length; k++) {
              if (k > 0) {
                this.formatted += " ";
              }
              this.formatted += comps[k].toString().trim();
            }
          }
        }
        return this.formatted;
      }
      format() {
        return this.range;
      }
      toString() {
        return this.range;
      }
      parseRange(range) {
        const memoOpts = (this.options.includePrerelease && FLAG_INCLUDE_PRERELEASE) | (this.options.loose && FLAG_LOOSE);
        const memoKey = memoOpts + ":" + range;
        const cached = cache.get(memoKey);
        if (cached) {
          return cached;
        }
        const loose = this.options.loose;
        const hr = loose ? re[t.HYPHENRANGELOOSE] : re[t.HYPHENRANGE];
        range = range.replace(hr, hyphenReplace(this.options.includePrerelease));
        debug("hyphen replace", range);
        range = range.replace(re[t.COMPARATORTRIM], comparatorTrimReplace);
        debug("comparator trim", range);
        range = range.replace(re[t.TILDETRIM], tildeTrimReplace);
        debug("tilde trim", range);
        range = range.replace(re[t.CARETTRIM], caretTrimReplace);
        debug("caret trim", range);
        let rangeList = range.split(" ").map((comp) => parseComparator(comp, this.options)).join(" ").split(/\s+/).map((comp) => replaceGTE0(comp, this.options));
        if (loose) {
          rangeList = rangeList.filter((comp) => {
            debug("loose invalid filter", comp, this.options);
            return !!comp.match(re[t.COMPARATORLOOSE]);
          });
        }
        debug("range list", rangeList);
        const rangeMap = /* @__PURE__ */ new Map();
        const comparators = rangeList.map((comp) => new Comparator(comp, this.options));
        for (const comp of comparators) {
          if (isNullSet(comp)) {
            return [comp];
          }
          rangeMap.set(comp.value, comp);
        }
        if (rangeMap.size > 1 && rangeMap.has("")) {
          rangeMap.delete("");
        }
        const result = [...rangeMap.values()];
        cache.set(memoKey, result);
        return result;
      }
      intersects(range, options) {
        if (!(range instanceof _Range)) {
          throw new TypeError("a Range is required");
        }
        return this.set.some((thisComparators) => {
          return isSatisfiable(thisComparators, options) && range.set.some((rangeComparators) => {
            return isSatisfiable(rangeComparators, options) && thisComparators.every((thisComparator) => {
              return rangeComparators.every((rangeComparator) => {
                return thisComparator.intersects(rangeComparator, options);
              });
            });
          });
        });
      }
      // if ANY of the sets match ALL of its comparators, then pass
      test(version) {
        if (!version) {
          return false;
        }
        if (typeof version === "string") {
          try {
            version = new SemVer(version, this.options);
          } catch (er) {
            return false;
          }
        }
        for (let i = 0; i < this.set.length; i++) {
          if (testSet(this.set[i], version, this.options)) {
            return true;
          }
        }
        return false;
      }
    };
    module.exports = Range;
    var LRU = require_lrucache();
    var cache = new LRU();
    var parseOptions = require_parse_options();
    var Comparator = require_comparator();
    var debug = require_debug();
    var SemVer = require_semver();
    var {
      safeRe: re,
      t,
      comparatorTrimReplace,
      tildeTrimReplace,
      caretTrimReplace
    } = require_re();
    var { FLAG_INCLUDE_PRERELEASE, FLAG_LOOSE } = require_constants();
    var isNullSet = (c) => c.value === "<0.0.0-0";
    var isAny = (c) => c.value === "";
    var isSatisfiable = (comparators, options) => {
      let result = true;
      const remainingComparators = comparators.slice();
      let testComparator = remainingComparators.pop();
      while (result && remainingComparators.length) {
        result = remainingComparators.every((otherComparator) => {
          return testComparator.intersects(otherComparator, options);
        });
        testComparator = remainingComparators.pop();
      }
      return result;
    };
    var parseComparator = (comp, options) => {
      comp = comp.replace(re[t.BUILD], "");
      debug("comp", comp, options);
      comp = replaceCarets(comp, options);
      debug("caret", comp);
      comp = replaceTildes(comp, options);
      debug("tildes", comp);
      comp = replaceXRanges(comp, options);
      debug("xrange", comp);
      comp = replaceStars(comp, options);
      debug("stars", comp);
      return comp;
    };
    var isX = (id) => !id || id.toLowerCase() === "x" || id === "*";
    var replaceTildes = (comp, options) => {
      return comp.trim().split(/\s+/).map((c) => replaceTilde(c, options)).join(" ");
    };
    var replaceTilde = (comp, options) => {
      const r = options.loose ? re[t.TILDELOOSE] : re[t.TILDE];
      return comp.replace(r, (_, M, m, p, pr) => {
        debug("tilde", comp, _, M, m, p, pr);
        let ret;
        if (isX(M)) {
          ret = "";
        } else if (isX(m)) {
          ret = `>=${M}.0.0 <${+M + 1}.0.0-0`;
        } else if (isX(p)) {
          ret = `>=${M}.${m}.0 <${M}.${+m + 1}.0-0`;
        } else if (pr) {
          debug("replaceTilde pr", pr);
          ret = `>=${M}.${m}.${p}-${pr} <${M}.${+m + 1}.0-0`;
        } else {
          ret = `>=${M}.${m}.${p} <${M}.${+m + 1}.0-0`;
        }
        debug("tilde return", ret);
        return ret;
      });
    };
    var replaceCarets = (comp, options) => {
      return comp.trim().split(/\s+/).map((c) => replaceCaret(c, options)).join(" ");
    };
    var replaceCaret = (comp, options) => {
      debug("caret", comp, options);
      const r = options.loose ? re[t.CARETLOOSE] : re[t.CARET];
      const z = options.includePrerelease ? "-0" : "";
      return comp.replace(r, (_, M, m, p, pr) => {
        debug("caret", comp, _, M, m, p, pr);
        let ret;
        if (isX(M)) {
          ret = "";
        } else if (isX(m)) {
          ret = `>=${M}.0.0${z} <${+M + 1}.0.0-0`;
        } else if (isX(p)) {
          if (M === "0") {
            ret = `>=${M}.${m}.0${z} <${M}.${+m + 1}.0-0`;
          } else {
            ret = `>=${M}.${m}.0${z} <${+M + 1}.0.0-0`;
          }
        } else if (pr) {
          debug("replaceCaret pr", pr);
          if (M === "0") {
            if (m === "0") {
              ret = `>=${M}.${m}.${p}-${pr} <${M}.${m}.${+p + 1}-0`;
            } else {
              ret = `>=${M}.${m}.${p}-${pr} <${M}.${+m + 1}.0-0`;
            }
          } else {
            ret = `>=${M}.${m}.${p}-${pr} <${+M + 1}.0.0-0`;
          }
        } else {
          debug("no pr");
          if (M === "0") {
            if (m === "0") {
              ret = `>=${M}.${m}.${p}${z} <${M}.${m}.${+p + 1}-0`;
            } else {
              ret = `>=${M}.${m}.${p}${z} <${M}.${+m + 1}.0-0`;
            }
          } else {
            ret = `>=${M}.${m}.${p} <${+M + 1}.0.0-0`;
          }
        }
        debug("caret return", ret);
        return ret;
      });
    };
    var replaceXRanges = (comp, options) => {
      debug("replaceXRanges", comp, options);
      return comp.split(/\s+/).map((c) => replaceXRange(c, options)).join(" ");
    };
    var replaceXRange = (comp, options) => {
      comp = comp.trim();
      const r = options.loose ? re[t.XRANGELOOSE] : re[t.XRANGE];
      return comp.replace(r, (ret, gtlt, M, m, p, pr) => {
        debug("xRange", comp, ret, gtlt, M, m, p, pr);
        const xM = isX(M);
        const xm = xM || isX(m);
        const xp = xm || isX(p);
        const anyX = xp;
        if (gtlt === "=" && anyX) {
          gtlt = "";
        }
        pr = options.includePrerelease ? "-0" : "";
        if (xM) {
          if (gtlt === ">" || gtlt === "<") {
            ret = "<0.0.0-0";
          } else {
            ret = "*";
          }
        } else if (gtlt && anyX) {
          if (xm) {
            m = 0;
          }
          p = 0;
          if (gtlt === ">") {
            gtlt = ">=";
            if (xm) {
              M = +M + 1;
              m = 0;
              p = 0;
            } else {
              m = +m + 1;
              p = 0;
            }
          } else if (gtlt === "<=") {
            gtlt = "<";
            if (xm) {
              M = +M + 1;
            } else {
              m = +m + 1;
            }
          }
          if (gtlt === "<") {
            pr = "-0";
          }
          ret = `${gtlt + M}.${m}.${p}${pr}`;
        } else if (xm) {
          ret = `>=${M}.0.0${pr} <${+M + 1}.0.0-0`;
        } else if (xp) {
          ret = `>=${M}.${m}.0${pr} <${M}.${+m + 1}.0-0`;
        }
        debug("xRange return", ret);
        return ret;
      });
    };
    var replaceStars = (comp, options) => {
      debug("replaceStars", comp, options);
      return comp.trim().replace(re[t.STAR], "");
    };
    var replaceGTE0 = (comp, options) => {
      debug("replaceGTE0", comp, options);
      return comp.trim().replace(re[options.includePrerelease ? t.GTE0PRE : t.GTE0], "");
    };
    var hyphenReplace = (incPr) => ($0, from, fM, fm, fp, fpr, fb, to, tM, tm, tp, tpr) => {
      if (isX(fM)) {
        from = "";
      } else if (isX(fm)) {
        from = `>=${fM}.0.0${incPr ? "-0" : ""}`;
      } else if (isX(fp)) {
        from = `>=${fM}.${fm}.0${incPr ? "-0" : ""}`;
      } else if (fpr) {
        from = `>=${from}`;
      } else {
        from = `>=${from}${incPr ? "-0" : ""}`;
      }
      if (isX(tM)) {
        to = "";
      } else if (isX(tm)) {
        to = `<${+tM + 1}.0.0-0`;
      } else if (isX(tp)) {
        to = `<${tM}.${+tm + 1}.0-0`;
      } else if (tpr) {
        to = `<=${tM}.${tm}.${tp}-${tpr}`;
      } else if (incPr) {
        to = `<${tM}.${tm}.${+tp + 1}-0`;
      } else {
        to = `<=${to}`;
      }
      return `${from} ${to}`.trim();
    };
    var testSet = (set, version, options) => {
      for (let i = 0; i < set.length; i++) {
        if (!set[i].test(version)) {
          return false;
        }
      }
      if (version.prerelease.length && !options.includePrerelease) {
        for (let i = 0; i < set.length; i++) {
          debug(set[i].semver);
          if (set[i].semver === Comparator.ANY) {
            continue;
          }
          if (set[i].semver.prerelease.length > 0) {
            const allowed = set[i].semver;
            if (allowed.major === version.major && allowed.minor === version.minor && allowed.patch === version.patch) {
              return true;
            }
          }
        }
        return false;
      }
      return true;
    };
  }
});

// node_modules/semver/classes/comparator.js
var require_comparator = __commonJS({
  "node_modules/semver/classes/comparator.js"(exports, module) {
    "use strict";
    var ANY = Symbol("SemVer ANY");
    var Comparator = class _Comparator {
      static get ANY() {
        return ANY;
      }
      constructor(comp, options) {
        options = parseOptions(options);
        if (comp instanceof _Comparator) {
          if (comp.loose === !!options.loose) {
            return comp;
          } else {
            comp = comp.value;
          }
        }
        comp = comp.trim().split(/\s+/).join(" ");
        debug("comparator", comp, options);
        this.options = options;
        this.loose = !!options.loose;
        this.parse(comp);
        if (this.semver === ANY) {
          this.value = "";
        } else {
          this.value = this.operator + this.semver.version;
        }
        debug("comp", this);
      }
      parse(comp) {
        const r = this.options.loose ? re[t.COMPARATORLOOSE] : re[t.COMPARATOR];
        const m = comp.match(r);
        if (!m) {
          throw new TypeError(`Invalid comparator: ${comp}`);
        }
        this.operator = m[1] !== void 0 ? m[1] : "";
        if (this.operator === "=") {
          this.operator = "";
        }
        if (!m[2]) {
          this.semver = ANY;
        } else {
          this.semver = new SemVer(m[2], this.options.loose);
        }
      }
      toString() {
        return this.value;
      }
      test(version) {
        debug("Comparator.test", version, this.options.loose);
        if (this.semver === ANY || version === ANY) {
          return true;
        }
        if (typeof version === "string") {
          try {
            version = new SemVer(version, this.options);
          } catch (er) {
            return false;
          }
        }
        return cmp(version, this.operator, this.semver, this.options);
      }
      intersects(comp, options) {
        if (!(comp instanceof _Comparator)) {
          throw new TypeError("a Comparator is required");
        }
        if (this.operator === "") {
          if (this.value === "") {
            return true;
          }
          return new Range(comp.value, options).test(this.value);
        } else if (comp.operator === "") {
          if (comp.value === "") {
            return true;
          }
          return new Range(this.value, options).test(comp.semver);
        }
        options = parseOptions(options);
        if (options.includePrerelease && (this.value === "<0.0.0-0" || comp.value === "<0.0.0-0")) {
          return false;
        }
        if (!options.includePrerelease && (this.value.startsWith("<0.0.0") || comp.value.startsWith("<0.0.0"))) {
          return false;
        }
        if (this.operator.startsWith(">") && comp.operator.startsWith(">")) {
          return true;
        }
        if (this.operator.startsWith("<") && comp.operator.startsWith("<")) {
          return true;
        }
        if (this.semver.version === comp.semver.version && this.operator.includes("=") && comp.operator.includes("=")) {
          return true;
        }
        if (cmp(this.semver, "<", comp.semver, options) && this.operator.startsWith(">") && comp.operator.startsWith("<")) {
          return true;
        }
        if (cmp(this.semver, ">", comp.semver, options) && this.operator.startsWith("<") && comp.operator.startsWith(">")) {
          return true;
        }
        return false;
      }
    };
    module.exports = Comparator;
    var parseOptions = require_parse_options();
    var { safeRe: re, t } = require_re();
    var cmp = require_cmp();
    var debug = require_debug();
    var SemVer = require_semver();
    var Range = require_range();
  }
});

// node_modules/semver/functions/satisfies.js
var require_satisfies = __commonJS({
  "node_modules/semver/functions/satisfies.js"(exports, module) {
    "use strict";
    var Range = require_range();
    var satisfies = (version, range, options) => {
      try {
        range = new Range(range, options);
      } catch (er) {
        return false;
      }
      return range.test(version);
    };
    module.exports = satisfies;
  }
});

// node_modules/semver/ranges/to-comparators.js
var require_to_comparators = __commonJS({
  "node_modules/semver/ranges/to-comparators.js"(exports, module) {
    "use strict";
    var Range = require_range();
    var toComparators = (range, options) => new Range(range, options).set.map((comp) => comp.map((c) => c.value).join(" ").trim().split(" "));
    module.exports = toComparators;
  }
});

// node_modules/semver/ranges/max-satisfying.js
var require_max_satisfying = __commonJS({
  "node_modules/semver/ranges/max-satisfying.js"(exports, module) {
    "use strict";
    var SemVer = require_semver();
    var Range = require_range();
    var maxSatisfying = (versions, range, options) => {
      let max = null;
      let maxSV = null;
      let rangeObj = null;
      try {
        rangeObj = new Range(range, options);
      } catch (er) {
        return null;
      }
      versions.forEach((v) => {
        if (rangeObj.test(v)) {
          if (!max || maxSV.compare(v) === -1) {
            max = v;
            maxSV = new SemVer(max, options);
          }
        }
      });
      return max;
    };
    module.exports = maxSatisfying;
  }
});

// node_modules/semver/ranges/min-satisfying.js
var require_min_satisfying = __commonJS({
  "node_modules/semver/ranges/min-satisfying.js"(exports, module) {
    "use strict";
    var SemVer = require_semver();
    var Range = require_range();
    var minSatisfying = (versions, range, options) => {
      let min = null;
      let minSV = null;
      let rangeObj = null;
      try {
        rangeObj = new Range(range, options);
      } catch (er) {
        return null;
      }
      versions.forEach((v) => {
        if (rangeObj.test(v)) {
          if (!min || minSV.compare(v) === 1) {
            min = v;
            minSV = new SemVer(min, options);
          }
        }
      });
      return min;
    };
    module.exports = minSatisfying;
  }
});

// node_modules/semver/ranges/min-version.js
var require_min_version = __commonJS({
  "node_modules/semver/ranges/min-version.js"(exports, module) {
    "use strict";
    var SemVer = require_semver();
    var Range = require_range();
    var gt = require_gt();
    var minVersion = (range, loose) => {
      range = new Range(range, loose);
      let minver = new SemVer("0.0.0");
      if (range.test(minver)) {
        return minver;
      }
      minver = new SemVer("0.0.0-0");
      if (range.test(minver)) {
        return minver;
      }
      minver = null;
      for (let i = 0; i < range.set.length; ++i) {
        const comparators = range.set[i];
        let setMin = null;
        comparators.forEach((comparator) => {
          const compver = new SemVer(comparator.semver.version);
          switch (comparator.operator) {
            case ">":
              if (compver.prerelease.length === 0) {
                compver.patch++;
              } else {
                compver.prerelease.push(0);
              }
              compver.raw = compver.format();
            /* fallthrough */
            case "":
            case ">=":
              if (!setMin || gt(compver, setMin)) {
                setMin = compver;
              }
              break;
            case "<":
            case "<=":
              break;
            /* istanbul ignore next */
            default:
              throw new Error(`Unexpected operation: ${comparator.operator}`);
          }
        });
        if (setMin && (!minver || gt(minver, setMin))) {
          minver = setMin;
        }
      }
      if (minver && range.test(minver)) {
        return minver;
      }
      return null;
    };
    module.exports = minVersion;
  }
});

// node_modules/semver/ranges/valid.js
var require_valid2 = __commonJS({
  "node_modules/semver/ranges/valid.js"(exports, module) {
    "use strict";
    var Range = require_range();
    var validRange = (range, options) => {
      try {
        return new Range(range, options).range || "*";
      } catch (er) {
        return null;
      }
    };
    module.exports = validRange;
  }
});

// node_modules/semver/ranges/outside.js
var require_outside = __commonJS({
  "node_modules/semver/ranges/outside.js"(exports, module) {
    "use strict";
    var SemVer = require_semver();
    var Comparator = require_comparator();
    var { ANY } = Comparator;
    var Range = require_range();
    var satisfies = require_satisfies();
    var gt = require_gt();
    var lt = require_lt();
    var lte = require_lte();
    var gte = require_gte();
    var outside = (version, range, hilo, options) => {
      version = new SemVer(version, options);
      range = new Range(range, options);
      let gtfn, ltefn, ltfn, comp, ecomp;
      switch (hilo) {
        case ">":
          gtfn = gt;
          ltefn = lte;
          ltfn = lt;
          comp = ">";
          ecomp = ">=";
          break;
        case "<":
          gtfn = lt;
          ltefn = gte;
          ltfn = gt;
          comp = "<";
          ecomp = "<=";
          break;
        default:
          throw new TypeError('Must provide a hilo val of "<" or ">"');
      }
      if (satisfies(version, range, options)) {
        return false;
      }
      for (let i = 0; i < range.set.length; ++i) {
        const comparators = range.set[i];
        let high = null;
        let low = null;
        comparators.forEach((comparator) => {
          if (comparator.semver === ANY) {
            comparator = new Comparator(">=0.0.0");
          }
          high = high || comparator;
          low = low || comparator;
          if (gtfn(comparator.semver, high.semver, options)) {
            high = comparator;
          } else if (ltfn(comparator.semver, low.semver, options)) {
            low = comparator;
          }
        });
        if (high.operator === comp || high.operator === ecomp) {
          return false;
        }
        if ((!low.operator || low.operator === comp) && ltefn(version, low.semver)) {
          return false;
        } else if (low.operator === ecomp && ltfn(version, low.semver)) {
          return false;
        }
      }
      return true;
    };
    module.exports = outside;
  }
});

// node_modules/semver/ranges/gtr.js
var require_gtr = __commonJS({
  "node_modules/semver/ranges/gtr.js"(exports, module) {
    "use strict";
    var outside = require_outside();
    var gtr = (version, range, options) => outside(version, range, ">", options);
    module.exports = gtr;
  }
});

// node_modules/semver/ranges/ltr.js
var require_ltr = __commonJS({
  "node_modules/semver/ranges/ltr.js"(exports, module) {
    "use strict";
    var outside = require_outside();
    var ltr = (version, range, options) => outside(version, range, "<", options);
    module.exports = ltr;
  }
});

// node_modules/semver/ranges/intersects.js
var require_intersects = __commonJS({
  "node_modules/semver/ranges/intersects.js"(exports, module) {
    "use strict";
    var Range = require_range();
    var intersects = (r1, r2, options) => {
      r1 = new Range(r1, options);
      r2 = new Range(r2, options);
      return r1.intersects(r2, options);
    };
    module.exports = intersects;
  }
});

// node_modules/semver/ranges/simplify.js
var require_simplify = __commonJS({
  "node_modules/semver/ranges/simplify.js"(exports, module) {
    "use strict";
    var satisfies = require_satisfies();
    var compare = require_compare();
    module.exports = (versions, range, options) => {
      const set = [];
      let first = null;
      let prev = null;
      const v = versions.sort((a, b) => compare(a, b, options));
      for (const version of v) {
        const included = satisfies(version, range, options);
        if (included) {
          prev = version;
          if (!first) {
            first = version;
          }
        } else {
          if (prev) {
            set.push([first, prev]);
          }
          prev = null;
          first = null;
        }
      }
      if (first) {
        set.push([first, null]);
      }
      const ranges = [];
      for (const [min, max] of set) {
        if (min === max) {
          ranges.push(min);
        } else if (!max && min === v[0]) {
          ranges.push("*");
        } else if (!max) {
          ranges.push(`>=${min}`);
        } else if (min === v[0]) {
          ranges.push(`<=${max}`);
        } else {
          ranges.push(`${min} - ${max}`);
        }
      }
      const simplified = ranges.join(" || ");
      const original = typeof range.raw === "string" ? range.raw : String(range);
      return simplified.length < original.length ? simplified : range;
    };
  }
});

// node_modules/semver/ranges/subset.js
var require_subset = __commonJS({
  "node_modules/semver/ranges/subset.js"(exports, module) {
    "use strict";
    var Range = require_range();
    var Comparator = require_comparator();
    var { ANY } = Comparator;
    var satisfies = require_satisfies();
    var compare = require_compare();
    var subset = (sub, dom, options = {}) => {
      if (sub === dom) {
        return true;
      }
      sub = new Range(sub, options);
      dom = new Range(dom, options);
      let sawNonNull = false;
      OUTER: for (const simpleSub of sub.set) {
        for (const simpleDom of dom.set) {
          const isSub = simpleSubset(simpleSub, simpleDom, options);
          sawNonNull = sawNonNull || isSub !== null;
          if (isSub) {
            continue OUTER;
          }
        }
        if (sawNonNull) {
          return false;
        }
      }
      return true;
    };
    var minimumVersionWithPreRelease = [new Comparator(">=0.0.0-0")];
    var minimumVersion = [new Comparator(">=0.0.0")];
    var simpleSubset = (sub, dom, options) => {
      if (sub === dom) {
        return true;
      }
      if (sub.length === 1 && sub[0].semver === ANY) {
        if (dom.length === 1 && dom[0].semver === ANY) {
          return true;
        } else if (options.includePrerelease) {
          sub = minimumVersionWithPreRelease;
        } else {
          sub = minimumVersion;
        }
      }
      if (dom.length === 1 && dom[0].semver === ANY) {
        if (options.includePrerelease) {
          return true;
        } else {
          dom = minimumVersion;
        }
      }
      const eqSet = /* @__PURE__ */ new Set();
      let gt, lt;
      for (const c of sub) {
        if (c.operator === ">" || c.operator === ">=") {
          gt = higherGT(gt, c, options);
        } else if (c.operator === "<" || c.operator === "<=") {
          lt = lowerLT(lt, c, options);
        } else {
          eqSet.add(c.semver);
        }
      }
      if (eqSet.size > 1) {
        return null;
      }
      let gtltComp;
      if (gt && lt) {
        gtltComp = compare(gt.semver, lt.semver, options);
        if (gtltComp > 0) {
          return null;
        } else if (gtltComp === 0 && (gt.operator !== ">=" || lt.operator !== "<=")) {
          return null;
        }
      }
      for (const eq of eqSet) {
        if (gt && !satisfies(eq, String(gt), options)) {
          return null;
        }
        if (lt && !satisfies(eq, String(lt), options)) {
          return null;
        }
        for (const c of dom) {
          if (!satisfies(eq, String(c), options)) {
            return false;
          }
        }
        return true;
      }
      let higher, lower;
      let hasDomLT, hasDomGT;
      let needDomLTPre = lt && !options.includePrerelease && lt.semver.prerelease.length ? lt.semver : false;
      let needDomGTPre = gt && !options.includePrerelease && gt.semver.prerelease.length ? gt.semver : false;
      if (needDomLTPre && needDomLTPre.prerelease.length === 1 && lt.operator === "<" && needDomLTPre.prerelease[0] === 0) {
        needDomLTPre = false;
      }
      for (const c of dom) {
        hasDomGT = hasDomGT || c.operator === ">" || c.operator === ">=";
        hasDomLT = hasDomLT || c.operator === "<" || c.operator === "<=";
        if (gt) {
          if (needDomGTPre) {
            if (c.semver.prerelease && c.semver.prerelease.length && c.semver.major === needDomGTPre.major && c.semver.minor === needDomGTPre.minor && c.semver.patch === needDomGTPre.patch) {
              needDomGTPre = false;
            }
          }
          if (c.operator === ">" || c.operator === ">=") {
            higher = higherGT(gt, c, options);
            if (higher === c && higher !== gt) {
              return false;
            }
          } else if (gt.operator === ">=" && !satisfies(gt.semver, String(c), options)) {
            return false;
          }
        }
        if (lt) {
          if (needDomLTPre) {
            if (c.semver.prerelease && c.semver.prerelease.length && c.semver.major === needDomLTPre.major && c.semver.minor === needDomLTPre.minor && c.semver.patch === needDomLTPre.patch) {
              needDomLTPre = false;
            }
          }
          if (c.operator === "<" || c.operator === "<=") {
            lower = lowerLT(lt, c, options);
            if (lower === c && lower !== lt) {
              return false;
            }
          } else if (lt.operator === "<=" && !satisfies(lt.semver, String(c), options)) {
            return false;
          }
        }
        if (!c.operator && (lt || gt) && gtltComp !== 0) {
          return false;
        }
      }
      if (gt && hasDomLT && !lt && gtltComp !== 0) {
        return false;
      }
      if (lt && hasDomGT && !gt && gtltComp !== 0) {
        return false;
      }
      if (needDomGTPre || needDomLTPre) {
        return false;
      }
      return true;
    };
    var higherGT = (a, b, options) => {
      if (!a) {
        return b;
      }
      const comp = compare(a.semver, b.semver, options);
      return comp > 0 ? a : comp < 0 ? b : b.operator === ">" && a.operator === ">=" ? b : a;
    };
    var lowerLT = (a, b, options) => {
      if (!a) {
        return b;
      }
      const comp = compare(a.semver, b.semver, options);
      return comp < 0 ? a : comp > 0 ? b : b.operator === "<" && a.operator === "<=" ? b : a;
    };
    module.exports = subset;
  }
});

// node_modules/semver/index.js
var require_semver2 = __commonJS({
  "node_modules/semver/index.js"(exports, module) {
    "use strict";
    var internalRe = require_re();
    var constants = require_constants();
    var SemVer = require_semver();
    var identifiers = require_identifiers();
    var parse = require_parse();
    var valid = require_valid();
    var clean = require_clean();
    var inc = require_inc();
    var diff = require_diff();
    var major = require_major();
    var minor = require_minor();
    var patch = require_patch();
    var prerelease = require_prerelease();
    var compare = require_compare();
    var rcompare = require_rcompare();
    var compareLoose = require_compare_loose();
    var compareBuild = require_compare_build();
    var sort = require_sort();
    var rsort = require_rsort();
    var gt = require_gt();
    var lt = require_lt();
    var eq = require_eq();
    var neq = require_neq();
    var gte = require_gte();
    var lte = require_lte();
    var cmp = require_cmp();
    var coerce = require_coerce();
    var Comparator = require_comparator();
    var Range = require_range();
    var satisfies = require_satisfies();
    var toComparators = require_to_comparators();
    var maxSatisfying = require_max_satisfying();
    var minSatisfying = require_min_satisfying();
    var minVersion = require_min_version();
    var validRange = require_valid2();
    var outside = require_outside();
    var gtr = require_gtr();
    var ltr = require_ltr();
    var intersects = require_intersects();
    var simplifyRange = require_simplify();
    var subset = require_subset();
    module.exports = {
      parse,
      valid,
      clean,
      inc,
      diff,
      major,
      minor,
      patch,
      prerelease,
      compare,
      rcompare,
      compareLoose,
      compareBuild,
      sort,
      rsort,
      gt,
      lt,
      eq,
      neq,
      gte,
      lte,
      cmp,
      coerce,
      Comparator,
      Range,
      satisfies,
      toComparators,
      maxSatisfying,
      minSatisfying,
      minVersion,
      validRange,
      outside,
      gtr,
      ltr,
      intersects,
      simplifyRange,
      subset,
      SemVer,
      re: internalRe.re,
      src: internalRe.src,
      tokens: internalRe.t,
      SEMVER_SPEC_VERSION: constants.SEMVER_SPEC_VERSION,
      RELEASE_TYPES: constants.RELEASE_TYPES,
      compareIdentifiers: identifiers.compareIdentifiers,
      rcompareIdentifiers: identifiers.rcompareIdentifiers
    };
  }
});

// node_modules/@shopify/shopify-api/dist/esm/adapters/web-api/adapter.mjs
async function webApiConvertRequest(adapterArgs) {
  const request = adapterArgs.rawRequest;
  const headers = {};
  for (const [key, value] of request.headers.entries()) {
    addHeader(headers, key, value);
  }
  return {
    headers,
    method: request.method ?? "GET",
    url: new URL(request.url).toString()
  };
}
async function webApiConvertHeaders(headers, _adapterArgs) {
  const remixHeaders = new Headers();
  flatHeaders(headers ?? {}).forEach(([key, value]) => remixHeaders.append(key, value));
  return Promise.resolve(remixHeaders);
}
async function webApiConvertResponse(resp, adapterArgs) {
  return new Response(resp.body, {
    status: resp.statusCode,
    statusText: resp.statusText,
    headers: await webApiConvertHeaders(resp.headers ?? {})
  });
}
function webApiRuntimeString() {
  return "Web API";
}

// node_modules/@shopify/shopify-api/dist/esm/adapters/web-api/index.mjs
setAbstractFetchFunc(fetch);
setAbstractConvertRequestFunc(webApiConvertRequest);
setAbstractConvertResponseFunc(webApiConvertResponse);
setAbstractConvertHeadersFunc(webApiConvertHeaders);
setAbstractRuntimeString(webApiRuntimeString);

// node_modules/@shopify/shopify-app-remix/dist/esm/server/boundary/headers.mjs
function headersBoundary(headers) {
  const { parentHeaders, loaderHeaders, actionHeaders, errorHeaders } = headers;
  if (errorHeaders && Array.from(errorHeaders.entries()).length > 0) {
    return errorHeaders;
  }
  return new Headers([
    ...parentHeaders ? Array.from(parentHeaders.entries()) : [],
    ...loaderHeaders ? Array.from(loaderHeaders.entries()) : [],
    ...actionHeaders ? Array.from(actionHeaders.entries()) : []
  ]);
}

// node_modules/@shopify/shopify-app-remix/dist/esm/server/boundary/error.mjs
var import_jsx_runtime = __toESM(require_jsx_runtime(), 1);
function errorBoundary(error) {
  if (error.constructor.name === "ErrorResponse" || error.constructor.name === "ErrorResponseImpl") {
    return (0, import_jsx_runtime.jsx)("div", { dangerouslySetInnerHTML: { __html: error.data || "Handling response" } });
  }
  throw error;
}

// node_modules/@shopify/shopify-app-remix/dist/esm/server/boundary/index.mjs
var boundary = {
  /**
   * A function that handles errors or thrown responses.
   *
   * @example
   * <caption>Catching errors in a route</caption>
   * ```ts
   * // /app/routes/admin/widgets.ts
   * import { boundary } from "@shopify/shopify-app-remix/server";
   *
   * export function ErrorBoundary() {
   *   return boundary.error(useRouteError());
   * }
   * ```
   */
  error: errorBoundary,
  /**
   * A function that sets the appropriate document response headers.
   *
   * @example
   * <caption>Catching errors in a route</caption>
   * ```ts
   * // /app/routes/admin/widgets.ts
   * import { boundary } from "@shopify/shopify-app-remix/server";
   *
   * export const headers = (headersArgs) => {
   *   return boundary.headers(headersArgs);
   * };
   * ```
   */
  headers: headersBoundary
};

// node_modules/@shopify/shopify-app-remix/dist/esm/server/version.mjs
var SHOPIFY_REMIX_LIBRARY_VERSION = "3.8.5";

// node_modules/@shopify/shopify-app-remix/dist/esm/server/authenticate/webhooks/register.mjs
function registerWebhooksFactory({ api, logger }) {
  return async function registerWebhooks({ session }) {
    return api.webhooks.register({ session }).then((response) => {
      Object.entries(response).forEach(([topic, topicResults]) => {
        topicResults.forEach(({ success, ...rest }) => {
          if (success) {
            logger.debug("Registered webhook", {
              topic,
              shop: session.shop,
              operation: rest.operation
            });
          } else {
            logger.error("Failed to register webhook", {
              topic,
              shop: session.shop,
              result: JSON.stringify(rest.result)
            });
          }
        });
      });
      return response;
    }).catch((error) => {
      var _a, _b;
      const graphQLErrors = ((_b = (_a = error.body) == null ? void 0 : _a.errors) == null ? void 0 : _b.graphQLErrors) || [];
      const throttled = graphQLErrors.find(({ extensions: { code } }) => code === "THROTTLED");
      if (throttled) {
        logger.error("Failed to register webhooks", {
          shop: session.shop,
          error: JSON.stringify(error)
        });
      } else {
        throw error;
      }
    });
  };
}

// node_modules/@shopify/shopify-app-remix/dist/esm/server/authenticate/helpers/ensure-cors-headers.mjs
function ensureCORSHeadersFactory(params, request, corsHeaders = []) {
  const { logger, config } = params;
  return function ensureCORSHeaders(response) {
    const origin = request.headers.get("Origin");
    if (origin && origin !== config.appUrl) {
      logger.debug("Request comes from a different origin, adding CORS headers");
      const corsHeadersSet = /* @__PURE__ */ new Set([
        "Authorization",
        "Content-Type",
        ...corsHeaders
      ]);
      response.headers.set("Access-Control-Allow-Origin", "*");
      response.headers.set("Access-Control-Allow-Headers", [...corsHeadersSet].join(", "));
      response.headers.set("Access-Control-Expose-Headers", REAUTH_URL_HEADER);
    }
    return response;
  };
}

// node_modules/@shopify/shopify-app-remix/dist/esm/server/authenticate/admin/helpers/redirect-to-bounce-page.mjs
init_esm();
var redirectToBouncePage = (params, url) => {
  const { config } = params;
  const searchParams = url.searchParams;
  searchParams.delete("id_token");
  searchParams.set("shopify-reload", `${config.appUrl}${url.pathname}?${searchParams.toString()}`);
  throw redirect(`${config.auth.patchSessionTokenPath}?${searchParams.toString()}`);
};

// node_modules/@shopify/shopify-app-remix/dist/esm/server/authenticate/helpers/respond-to-invalid-session-token.mjs
function respondToInvalidSessionToken({ params, request, retryRequest = false }) {
  const { api, logger, config } = params;
  const isDocumentRequest = !request.headers.get("authorization");
  if (isDocumentRequest) {
    return redirectToBouncePage({ config }, new URL(request.url));
  }
  throw new Response(void 0, {
    status: 401,
    statusText: "Unauthorized",
    headers: retryRequest ? RETRY_INVALID_SESSION_HEADER : {}
  });
}

// node_modules/@shopify/shopify-app-remix/dist/esm/server/authenticate/helpers/get-shop-from-request.mjs
function getShopFromRequest(request) {
  const url = new URL(request.url);
  return url.searchParams.get("shop");
}

// node_modules/@shopify/shopify-app-remix/dist/esm/server/authenticate/helpers/validate-session-token.mjs
async function validateSessionToken(params, request, token, { checkAudience = true, retryRequest = true } = {}) {
  const { api, logger } = params;
  const shop = getShopFromRequest(request);
  logger.debug("Validating session token", { shop });
  try {
    const payload = await api.session.decodeSessionToken(token, {
      checkAudience
    });
    logger.debug("Session token is valid - validated", {
      shop,
      payload: JSON.stringify(payload)
    });
    return payload;
  } catch (error) {
    logger.debug(`Failed to validate session token: ${error.message}`, {
      shop
    });
    throw respondToInvalidSessionToken({ params, request, retryRequest });
  }
}

// node_modules/@shopify/shopify-app-remix/dist/esm/server/authenticate/helpers/get-session-token-header.mjs
var SESSION_TOKEN_PARAM = "id_token";
function getSessionTokenHeader(request) {
  var _a;
  return (_a = request.headers.get("authorization")) == null ? void 0 : _a.replace("Bearer ", "");
}
function getSessionTokenFromUrlParam(request) {
  const url = new URL(request.url);
  return url.searchParams.get(SESSION_TOKEN_PARAM);
}

// node_modules/@shopify/shopify-app-remix/dist/esm/server/authenticate/helpers/reject-bot-request.mjs
var SHOPIFY_POS_USER_AGENT = /Shopify POS\//;
var SHOPIFY_MOBILE_USER_AGENT = /Shopify Mobile\//;
var SHOPIFY_USER_AGENTS = [SHOPIFY_POS_USER_AGENT, SHOPIFY_MOBILE_USER_AGENT];
function respondToBotRequest({ logger }, request) {
  const userAgent = request.headers.get("User-Agent") ?? "";
  if (SHOPIFY_USER_AGENTS.some((agent) => agent.test(userAgent))) {
    logger.debug("Request is from a Shopify agent, allow");
    return;
  }
  if (isbot(userAgent)) {
    logger.debug("Request is from a bot, skipping auth");
    throw new Response(void 0, { status: 410, statusText: "Gone" });
  }
}

// node_modules/@shopify/shopify-app-remix/dist/esm/server/authenticate/helpers/respond-to-options-request.mjs
function respondToOptionsRequest(params, request, corsHeaders) {
  if (request.method === "OPTIONS") {
    const ensureCORSHeaders = ensureCORSHeadersFactory(params, request, corsHeaders);
    throw ensureCORSHeaders(new Response(null, {
      status: 204,
      headers: {
        "Access-Control-Max-Age": "7200"
      }
    }));
  }
}

// node_modules/@shopify/shopify-app-remix/dist/esm/server/authenticate/admin/authenticate.mjs
init_esm();

// node_modules/@shopify/shopify-app-remix/dist/esm/server/authenticate/admin/billing/cancel.mjs
init_esm();

// node_modules/@shopify/shopify-app-remix/dist/esm/server/authenticate/admin/helpers/begin-auth.mjs
async function beginAuth(params, request, isOnline, shop) {
  const { api, config } = params;
  throw await api.auth.begin({
    shop,
    callbackPath: config.auth.callbackPath,
    isOnline,
    rawRequest: request
  });
}

// node_modules/@shopify/shopify-app-remix/dist/esm/server/authenticate/admin/helpers/redirect-with-exitiframe.mjs
init_esm();
function redirectWithExitIframe(params, request, shop) {
  const { api, config } = params;
  const url = new URL(request.url);
  const queryParams = url.searchParams;
  const host = api.utils.sanitizeHost(queryParams.get("host"));
  queryParams.set("shop", shop);
  let destination = `${config.auth.path}?shop=${shop}`;
  if (host) {
    queryParams.set("host", host);
    destination = `${destination}&host=${host}`;
  }
  queryParams.set("exitIframe", destination);
  throw redirect(`${config.auth.exitIframePath}?${queryParams.toString()}`);
}

// node_modules/@shopify/shopify-app-remix/dist/esm/server/authenticate/admin/helpers/redirect-with-app-bridge-headers.mjs
function redirectWithAppBridgeHeaders(redirectUri) {
  throw new Response(void 0, {
    status: 401,
    statusText: "Unauthorized",
    headers: getAppBridgeHeaders(redirectUri)
  });
}
function getAppBridgeHeaders(url) {
  return new Headers({ [REAUTH_URL_HEADER]: url });
}

// node_modules/@shopify/shopify-app-remix/dist/esm/server/authenticate/admin/helpers/redirect-to-auth-page.mjs
async function redirectToAuthPage(params, request, shop, isOnline = false) {
  const { config } = params;
  const url = new URL(request.url);
  const isEmbeddedRequest2 = url.searchParams.get("embedded") === "1";
  const isXhrRequest = request.headers.get("authorization");
  if (isXhrRequest) {
    const redirectUri = new URL(config.auth.path, config.appUrl);
    redirectUri.searchParams.set("shop", shop);
    redirectWithAppBridgeHeaders(redirectUri.toString());
  } else if (isEmbeddedRequest2) {
    redirectWithExitIframe(params, request, shop);
  } else {
    throw await beginAuth(params, request, isOnline, shop);
  }
}

// node_modules/@shopify/shopify-app-remix/dist/esm/server/authenticate/helpers/invalidate-access-token.mjs
async function invalidateAccessToken(params, session) {
  const { logger, config } = params;
  logger.debug(`Invalidating access token for session - ${session.id}`, {
    shop: session.shop
  });
  session.accessToken = void 0;
  await config.sessionStorage.storeSession(session);
}

// node_modules/@shopify/shopify-app-remix/dist/esm/server/authenticate/admin/billing/cancel.mjs
function cancelBillingFactory(params, request, session) {
  return async function cancelBilling(options) {
    const { api, logger } = params;
    logger.debug("Cancelling billing", { shop: session.shop, ...options });
    try {
      return await api.billing.cancel({
        session,
        subscriptionId: options.subscriptionId,
        isTest: options.isTest,
        prorate: options.prorate
      });
    } catch (error) {
      if (error instanceof HttpResponseError && error.response.code === 401) {
        logger.debug("API token was invalid, redirecting to OAuth", {
          shop: session.shop
        });
        await invalidateAccessToken(params, session);
        throw await redirectToAuthPage(params, request, session.shop);
      } else {
        throw error;
      }
    }
  };
}

// node_modules/@shopify/shopify-app-remix/dist/esm/server/authenticate/admin/billing/require.mjs
init_esm();
function requireBillingFactory(params, request, session) {
  const { api, logger } = params;
  return async function requireBilling(options) {
    const logContext = {
      shop: session.shop,
      plans: options.plans,
      isTest: options.isTest
    };
    logger.debug("Checking billing for the shop", logContext);
    let data;
    try {
      data = await api.billing.check({
        session,
        plans: options.plans,
        isTest: options.isTest,
        returnObject: true
      });
    } catch (error) {
      if (error instanceof HttpResponseError && error.response.code === 401) {
        logger.debug("API token was invalid, redirecting to OAuth", logContext);
        await invalidateAccessToken(params, session);
        throw await redirectToAuthPage(params, request, session.shop);
      } else {
        throw error;
      }
    }
    if (!data.hasActivePayment) {
      logger.debug("Billing check failed", logContext);
      throw await options.onFailure(new Error("Billing check failed"));
    }
    logger.debug("Billing check succeeded", logContext);
    return data;
  };
}

// node_modules/@shopify/shopify-app-remix/dist/esm/server/authenticate/admin/billing/request.mjs
init_esm();

// node_modules/@shopify/shopify-app-remix/dist/esm/server/authenticate/admin/billing/helpers.mjs
init_esm();
function redirectOutOfApp(params, request, url, shop) {
  const { config, logger } = params;
  logger.debug("Redirecting out of app", { shop, url });
  const requestUrl = new URL(request.url);
  const isEmbeddedRequest2 = requestUrl.searchParams.get("embedded") === "1";
  const isXhrRequest = request.headers.get("authorization");
  if (isXhrRequest) {
    throw new Response(void 0, {
      status: 401,
      statusText: "Unauthorized",
      headers: getAppBridgeHeaders(url)
    });
  } else if (isEmbeddedRequest2) {
    const params2 = new URLSearchParams({
      shop,
      host: requestUrl.searchParams.get("host"),
      exitIframe: url
    });
    throw redirect(`${config.auth.exitIframePath}?${params2.toString()}`);
  } else {
    throw redirect(url);
  }
}

// node_modules/@shopify/shopify-app-remix/dist/esm/server/authenticate/admin/billing/request.mjs
function requestBillingFactory(params, request, session) {
  return async function requestBilling({ plan, isTest, returnUrl, ...overrides }) {
    const { api, logger } = params;
    logger.info("Requesting billing", {
      shop: session.shop,
      plan,
      isTest,
      returnUrl
    });
    let result;
    try {
      result = await api.billing.request({
        plan,
        session,
        isTest,
        returnUrl,
        returnObject: true,
        ...overrides
      });
    } catch (error) {
      if (error instanceof HttpResponseError && error.response.code === 401) {
        logger.debug("API token was invalid, redirecting to OAuth", {
          shop: session.shop
        });
        await invalidateAccessToken(params, session);
        throw await redirectToAuthPage(params, request, session.shop);
      } else {
        throw error;
      }
    }
    throw redirectOutOfApp(params, request, result.confirmationUrl, session.shop);
  };
}

// node_modules/@shopify/shopify-app-remix/dist/esm/server/authenticate/admin/billing/check.mjs
init_esm();
function checkBillingFactory(params, request, session) {
  return async function checkBilling(options = {}) {
    const { api, logger } = params;
    logger.debug("Checking billing plans", { shop: session.shop, ...options });
    try {
      return await api.billing.check({
        session,
        plans: options.plans,
        isTest: options.isTest,
        returnObject: true
      });
    } catch (error) {
      if (error instanceof HttpResponseError && error.response.code === 401) {
        logger.debug("API token was invalid, redirecting to OAuth", {
          shop: session.shop
        });
        await invalidateAccessToken(params, session);
        throw await redirectToAuthPage(params, request, session.shop);
      } else {
        throw error;
      }
    }
  };
}

// node_modules/@shopify/shopify-app-remix/dist/esm/server/authenticate/admin/billing/create-usage-record.mjs
init_esm();
function createUsageRecordFactory(params, request, session) {
  return async function createUsageRecord(options) {
    const { api, logger } = params;
    logger.debug("Create usage record", { shop: session.shop, ...options });
    try {
      return await api.billing.createUsageRecord({
        ...options,
        session
      });
    } catch (error) {
      if (error instanceof HttpResponseError && error.response.code === 401) {
        logger.debug("API token was invalid, redirecting to OAuth", {
          shop: session.shop
        });
        await invalidateAccessToken(params, session);
        throw await redirectToAuthPage(params, request, session.shop);
      } else {
        throw error;
      }
    }
  };
}

// node_modules/@shopify/shopify-app-remix/dist/esm/server/authenticate/admin/billing/update-usage-subscription-capped-amount.mjs
init_esm();
function updateUsageCappedAmountFactory(params, request, session) {
  return async function updateUsageCappedAmount(options) {
    const { api, logger } = params;
    logger.debug("Updating usage subscription capped amount", {
      shop: session.shop,
      ...options
    });
    let result;
    try {
      result = await api.billing.updateUsageCappedAmount({
        session,
        subscriptionLineItemId: options.subscriptionLineItemId,
        cappedAmount: options.cappedAmount
      });
    } catch (error) {
      if (error instanceof HttpResponseError && error.response.code === 401) {
        logger.debug("API token was invalid, redirecting to OAuth", {
          shop: session.shop
        });
        await invalidateAccessToken(params, session);
        throw await redirectToAuthPage(params, request, session.shop);
      } else {
        throw error;
      }
    }
    throw redirectOutOfApp(params, request, result.confirmationUrl, session.shop);
  };
}

// node_modules/@shopify/shopify-app-remix/dist/esm/server/clients/admin/graphql.mjs
function graphqlClientFactory({ params, handleClientError, session }) {
  return async function query(operation, options) {
    const client = new params.api.clients.Graphql({
      session,
      apiVersion: options == null ? void 0 : options.apiVersion
    });
    try {
      const apiResponse = await client.request(operation, {
        variables: options == null ? void 0 : options.variables,
        retries: (options == null ? void 0 : options.tries) ? options.tries - 1 : 0,
        headers: options == null ? void 0 : options.headers,
        signal: options == null ? void 0 : options.signal
      });
      return new Response(JSON.stringify(apiResponse));
    } catch (error) {
      if (handleClientError) {
        throw await handleClientError({ error, params, session });
      }
      throw error;
    }
  };
}

// node_modules/@shopify/shopify-app-remix/dist/esm/server/clients/admin/rest.mjs
function restClientFactory({ params, handleClientError, session }) {
  const { api } = params;
  const client = new RemixRestClient({
    params,
    handleClientError,
    session
  });
  if (api.rest) {
    client.resources = {};
    const RestResourceClient = restResourceClientFactory({
      params,
      handleClientError,
      session
    });
    Object.entries(api.rest).forEach(([name, resource]) => {
      class RemixResource extends resource {
      }
      __publicField(RemixResource, "Client", RestResourceClient);
      Reflect.defineProperty(RemixResource, "name", {
        value: name
      });
      Reflect.set(client.resources, name, RemixResource);
    });
  }
  return client;
}
var RemixRestClient = class {
  constructor({ params, session, handleClientError }) {
    __publicField(this, "session");
    __publicField(this, "params");
    __publicField(this, "handleClientError");
    this.params = params;
    this.handleClientError = handleClientError;
    this.session = session;
  }
  /**
   * Performs a GET request on the given path.
   *
   * @deprecated In a future major release REST will be removed from this package. Please see [all-in on graphql](https://www.shopify.com/ca/partners/blog/all-in-on-graphql).
   */
  async get(params) {
    return this.makeRequest({
      method: "GET",
      ...params
    });
  }
  /**
   * Performs a POST request on the given path.
   *
   * @deprecated In a future major release REST will be removed from this package. Please see [all-in on graphql](https://www.shopify.com/ca/partners/blog/all-in-on-graphql).
   */
  async post(params) {
    return this.makeRequest({
      method: "POST",
      ...params
    });
  }
  /**
   * Performs a PUT request on the given path.
   *
   * @deprecated In a future major release REST will be removed from this package. Please see [all-in on graphql](https://www.shopify.com/ca/partners/blog/all-in-on-graphql).
   */
  async put(params) {
    return this.makeRequest({
      method: "PUT",
      ...params
    });
  }
  /**
   * Performs a DELETE request on the given path.
   *
   * @deprecated In a future major release REST will be removed from this package. Please see [all-in on graphql](https://www.shopify.com/ca/partners/blog/all-in-on-graphql).
   */
  async delete(params) {
    return this.makeRequest({
      method: "DELETE",
      ...params
    });
  }
  async makeRequest(params) {
    const originalClient = new this.params.api.clients.Rest({
      session: this.session
    });
    const originalRequest = Reflect.get(originalClient, "request");
    try {
      const apiResponse = await originalRequest.call(originalClient, params);
      return new Response(JSON.stringify(apiResponse.body), {
        headers: apiResponse.headers
      });
    } catch (error) {
      if (this.handleClientError) {
        throw await this.handleClientError({
          error,
          session: this.session,
          params: this.params
        });
      } else
        throw new Error(error);
    }
  }
};
function restResourceClientFactory({ params, handleClientError, session }) {
  const { api } = params;
  const ApiClient = api.clients.Rest;
  return class RestResourceClient extends ApiClient {
    async request(requestParams) {
      const originalClient = new api.clients.Rest({ session });
      const originalRequest = Reflect.get(originalClient, "request");
      try {
        return await originalRequest.call(originalClient, requestParams);
      } catch (error) {
        if (handleClientError) {
          throw await handleClientError({ error, params, session });
        } else
          throw new Error(error);
      }
    }
  };
}

// node_modules/@shopify/shopify-app-remix/dist/esm/server/clients/admin/factory.mjs
function adminClientFactory({ params, handleClientError, session }) {
  if (params.config.future.removeRest) {
    return {
      graphql: graphqlClientFactory({ params, session, handleClientError })
    };
  }
  return {
    rest: restClientFactory({
      params,
      session,
      handleClientError
    }),
    graphql: graphqlClientFactory({ params, session, handleClientError })
  };
}

// node_modules/@shopify/shopify-app-remix/dist/esm/server/authenticate/admin/helpers/create-admin-api-context.mjs
function createAdminApiContext(session, params, handleClientError) {
  return adminClientFactory({
    session,
    params,
    handleClientError
  });
}

// node_modules/@shopify/shopify-app-remix/dist/esm/server/authenticate/admin/helpers/redirect-to-shopify-or-app-root.mjs
init_esm();
async function redirectToShopifyOrAppRoot(request, params, responseHeaders) {
  const { api } = params;
  const url = new URL(request.url);
  const host = api.utils.sanitizeHost(url.searchParams.get("host"));
  const shop = api.utils.sanitizeShop(url.searchParams.get("shop"));
  const redirectUrl = api.config.isEmbeddedApp ? await api.auth.getEmbeddedAppUrl({ rawRequest: request }) : `/?shop=${shop}&host=${encodeURIComponent(host)}`;
  throw redirect(redirectUrl, { headers: responseHeaders });
}

// node_modules/@shopify/shopify-app-remix/dist/esm/server/authenticate/admin/helpers/ensure-app-is-embedded-if-required.mjs
var ensureAppIsEmbeddedIfRequired = async (params, request) => {
  const { api, logger, config } = params;
  const url = new URL(request.url);
  const shop = url.searchParams.get("shop");
  if (api.config.isEmbeddedApp && url.searchParams.get("embedded") !== "1") {
    logger.debug("App is not embedded, redirecting to Shopify", { shop });
    await redirectToShopifyOrAppRoot(request, { api });
  }
};

// node_modules/@shopify/shopify-app-remix/dist/esm/server/authenticate/admin/helpers/ensure-session-token-search-param-if-required.mjs
var SESSION_TOKEN_PARAM2 = "id_token";
var ensureSessionTokenSearchParamIfRequired = async (params, request) => {
  const { api, logger } = params;
  const url = new URL(request.url);
  const shop = url.searchParams.get("shop");
  const searchParamSessionToken = url.searchParams.get(SESSION_TOKEN_PARAM2);
  const isEmbedded = url.searchParams.get("embedded") === "1";
  if (api.config.isEmbeddedApp && isEmbedded && !searchParamSessionToken) {
    logger.debug("Missing session token in search params, going to bounce page", { shop });
    redirectToBouncePage(params, url);
  }
};

// node_modules/@shopify/shopify-app-remix/dist/esm/server/authenticate/admin/helpers/redirect.mjs
init_esm();

// node_modules/@shopify/shopify-app-remix/dist/esm/server/authenticate/helpers/add-response-headers.mjs
function addDocumentResponseHeadersFactory(params) {
  const { api, config } = params;
  return function(request, headers) {
    const { searchParams } = new URL(request.url);
    const shop = api.utils.sanitizeShop(searchParams.get("shop"));
    addDocumentResponseHeaders(headers, config.isEmbeddedApp, shop);
  };
}
function addDocumentResponseHeaders(headers, isEmbeddedApp, shop) {
  if (shop) {
    headers.set("Link", '<https://cdn.shopify.com/shopifycloud/app-bridge.js>; rel="preload"; as="script";');
  }
  if (isEmbeddedApp) {
    if (shop) {
      headers.set("Content-Security-Policy", `frame-ancestors https://${shop} https://admin.shopify.com https://*.spin.dev https://admin.myshopify.io https://admin.shop.dev;`);
    }
  } else {
    headers.set("Content-Security-Policy", `frame-ancestors 'none';`);
  }
}

// node_modules/@shopify/shopify-app-remix/dist/esm/server/authenticate/admin/helpers/validate-redirect-url.mjs
var FILE_URI_MATCH = /\/\/\//;
var INVALID_RELATIVE_URL = /[/\\][/\\]/;
var WHITESPACE_CHARACTER = /\s/;
var VALID_PROTOCOLS = ["https:", "http:"];
function isSafe(domain, redirectUrl, requireSSL = true) {
  if (typeof redirectUrl !== "string") {
    return false;
  }
  if (FILE_URI_MATCH.test(redirectUrl) || WHITESPACE_CHARACTER.test(redirectUrl)) {
    return false;
  }
  let url;
  try {
    url = new URL(redirectUrl, domain);
  } catch (error) {
    return false;
  }
  if (INVALID_RELATIVE_URL.test(url.pathname)) {
    return false;
  }
  if (!VALID_PROTOCOLS.includes(url.protocol)) {
    return false;
  }
  if (requireSSL && url.protocol !== "https:") {
    return false;
  }
  return true;
}
function sanitizeRedirectUrl(domain, redirectUrl, options = {}) {
  if (isSafe(domain, redirectUrl, options.requireSSL)) {
    return new URL(redirectUrl, domain);
  } else if (options.throwOnInvalid === false) {
    return void 0;
  } else {
    throw new ShopifyError("Invalid URL. Refusing to redirect");
  }
}

// node_modules/@shopify/shopify-app-remix/dist/esm/server/authenticate/admin/helpers/render-app-bridge.mjs
function renderAppBridge({ config }, request, redirectTo) {
  let redirectToScript = "";
  if (redirectTo) {
    const destination = sanitizeRedirectUrl(config.appUrl, redirectTo.url);
    const target = redirectTo.target ?? "_top";
    redirectToScript = `<script>window.open(${JSON.stringify(destination.toString())}, ${JSON.stringify(target)})<\/script>`;
  }
  const responseHeaders = new Headers({
    "content-type": "text/html;charset=utf-8"
  });
  addDocumentResponseHeaders(responseHeaders, config.isEmbeddedApp, new URL(request.url).searchParams.get("shop"));
  throw new Response(`
      <script data-api-key="${config.apiKey}" src="${appBridgeUrl()}"><\/script>
      ${redirectToScript}
    `, { headers: responseHeaders });
}

// node_modules/@shopify/shopify-app-remix/dist/esm/server/authenticate/admin/helpers/redirect.mjs
function redirectFactory(params, request, shop) {
  const { config, logger } = params;
  return function redirect$1(url, init) {
    const { searchParams } = new URL(request.url);
    const { url: parsedUrl, target } = parseURL({
      params,
      url,
      base: config.appUrl,
      shop,
      init
    });
    logger.debug("Redirecting", { shop, url: parsedUrl.toString() });
    const isSameOrigin = parsedUrl.origin === config.appUrl;
    if (isSameOrigin || url.startsWith("/")) {
      searchParams.forEach((value, key) => {
        if (!parsedUrl.searchParams.has(key)) {
          parsedUrl.searchParams.set(key, value);
        }
      });
    }
    if (target === "_self") {
      if (isBounceRequest(request)) {
        throw renderAppBridge(params, request, {
          url: parsedUrl.toString(),
          target
        });
      } else {
        return redirect(parsedUrl.toString(), init);
      }
    } else if (isDataRequest(request)) {
      throw redirectWithAppBridgeHeaders(parsedUrl.toString());
    } else if (isEmbeddedRequest(request)) {
      throw renderAppBridge(params, request, {
        url: parsedUrl.toString(),
        target
      });
    }
    return redirect(url, init);
  };
}
function isBounceRequest(request) {
  return Boolean(getSessionTokenHeader(request)) && request.headers.has("X-Shopify-Bounce");
}
function isDataRequest(request) {
  const isGet = request.method === "GET";
  const sessionTokenHeader = Boolean(getSessionTokenHeader(request));
  return sessionTokenHeader && !isBounceRequest(request) && (!isEmbeddedRequest(request) || !isGet);
}
function isEmbeddedRequest(request) {
  const { searchParams } = new URL(request.url);
  return searchParams.get("embedded") === "1";
}
function parseURL({ params, base, init, shop, url }) {
  let target = typeof init !== "number" && (init == null ? void 0 : init.target) ? init.target : void 0;
  if (isAdminRemotePath(url)) {
    const { config } = params;
    const adminPath = getAdminRemotePath(url);
    const cleanShopName = shop.replace(".myshopify.com", "");
    if (!target) {
      target = config.isEmbeddedApp ? "_parent" : "_self";
    }
    return {
      url: new URL(`https://admin.shopify.com/store/${cleanShopName}${adminPath}`),
      target
    };
  } else {
    return {
      url: new URL(url, base),
      target: target ?? "_self"
    };
  }
}
var ADMIN_REGEX = /^shopify:\/*admin\//i;
function isAdminRemotePath(url) {
  return ADMIN_REGEX.test(url);
}
function getAdminRemotePath(url) {
  const parsedUrl = removeRestrictedParams(new URL(url)).href;
  return parsedUrl.replace(ADMIN_REGEX, "/");
}
var embeddedFrameParamsToRemove = [
  "hmac",
  "locale",
  "protocol",
  "session",
  "id_token",
  "shop",
  "timestamp",
  "host",
  "embedded",
  // sent when clicking rel="home" nav item
  "appLoadId"
];
function removeRestrictedParams(url) {
  const newUrl = new URL(url);
  embeddedFrameParamsToRemove.forEach((param) => newUrl.searchParams.delete(param));
  return newUrl;
}

// node_modules/@shopify/shopify-app-remix/dist/esm/server/authenticate/admin/helpers/validate-shop-and-host-params.mjs
init_esm();
function validateShopAndHostParams(params, request) {
  const { api, config, logger } = params;
  if (config.isEmbeddedApp) {
    const url = new URL(request.url);
    const shop = api.utils.sanitizeShop(url.searchParams.get("shop"));
    if (!shop) {
      logger.debug("Missing or invalid shop, redirecting to login path", {
        shop
      });
      throw redirectToLoginPath(request, params);
    }
    const host = api.utils.sanitizeHost(url.searchParams.get("host"));
    if (!host) {
      logger.debug("Invalid host, redirecting to login path", {
        shop,
        host: url.searchParams.get("host")
      });
      throw redirectToLoginPath(request, params);
    }
  }
}
function redirectToLoginPath(request, params) {
  const { config, logger } = params;
  const { pathname } = new URL(request.url);
  if (pathname === config.auth.loginPath) {
    const message = `Detected call to shopify.authenticate.admin() from configured login path ('${config.auth.loginPath}'), please make sure to call shopify.login() from that route instead.`;
    logger.debug(message);
    throw new Response(message, { status: 500 });
  }
  throw redirect(config.auth.loginPath);
}

// node_modules/@shopify/shopify-app-remix/dist/esm/server/authenticate/admin/helpers/redirect-to-install-page.mjs
init_esm();
async function redirectToInstallPage(params, shop, optionalScopes = []) {
  const installUrl = buildInstallUrl(params, shop, optionalScopes);
  if (params.config.isEmbeddedApp) {
    throw redirectWithAppBridgeHeaders(installUrl);
  } else {
    throw redirect(installUrl);
  }
}
function buildInstallUrl(params, shop, optionalScopes = []) {
  const baseInstallUrl = buildBaseInstallUrl(params, shop);
  baseInstallUrl.search = buildParamsInstallUrl(params, optionalScopes).toString();
  return baseInstallUrl.href;
}
function buildBaseInstallUrl({ api }, shop) {
  const cleanShop = api.utils.sanitizeShop(shop, true);
  return new URL(`https://${cleanShop}/admin/oauth/install`);
}
function buildParamsInstallUrl({ config }, optionalScopes = []) {
  var _a;
  const optionalScopesParam = optionalScopes && optionalScopes.length > 0 ? { optional_scopes: optionalScopes.join(",") } : void 0;
  const query = {
    client_id: config.apiKey,
    scope: ((_a = config.scopes) == null ? void 0 : _a.toString()) || "",
    ...optionalScopesParam
  };
  return new URLSearchParams(query);
}

// node_modules/@shopify/shopify-app-remix/dist/esm/server/authenticate/admin/scope/client/fetch-scopes-details.mjs
var FETCH_SCOPES_DETAIL_QUERY = `#graphql
query FetchAccessScopes{
  app {
    requestedAccessScopes {
      handle
    }
    optionalAccessScopes {
      handle
    }
    installation {
      accessScopes {
        handle
      }
    }
  }
}`;
async function fetchScopeDetail(admin) {
  const fetchScopeDetailResult = await admin.graphql(FETCH_SCOPES_DETAIL_QUERY);
  const resultContent = await fetchScopeDetailResult.json();
  return resultContent.data;
}

// node_modules/@shopify/shopify-app-remix/dist/esm/server/authenticate/admin/scope/request.mjs
function requestScopesFactory(params, session, admin) {
  return async function requestScopes(scopes) {
    const { logger } = params;
    logger.debug("Requesting optional scopes: ", { shop: session.shop, scopes });
    if (scopes.length === 0)
      return;
    if (await alreadyGranted(scopes, admin))
      return;
    throw await redirectToInstallPage(params, session.shop, scopes);
  };
  async function alreadyGranted(scopes, admin2) {
    const scopesDetail = await fetchScopeDetail(admin2);
    const grantedScopes = scopesDetail.app.installation.accessScopes.map((scope) => scope.handle);
    return new AuthScopes(grantedScopes).has(scopes);
  }
}

// node_modules/@shopify/shopify-app-remix/dist/esm/server/authenticate/admin/scope/query.mjs
function queryScopesFactory(params, session, admin) {
  return async function queryScopes() {
    const { logger } = params;
    logger.debug("Querying scopes details: ", {
      shop: session.shop
    });
    const scopesDetail = await fetchScopeDetail(admin);
    return mapFetchScopeDetail(scopesDetail);
  };
}
function mapFetchScopeDetail(scopesDetailResponse) {
  const appInformation = scopesDetailResponse.app;
  const granted = new AuthScopes(appInformation.installation.accessScopes.map((scope) => scope.handle)).toArray(true);
  const required = new AuthScopes(appInformation.requestedAccessScopes.map((scope) => scope.handle)).toArray(true);
  const optional = new AuthScopes(appInformation.optionalAccessScopes.map((scope) => scope.handle)).toArray(true);
  return {
    granted,
    required,
    optional
  };
}

// node_modules/@shopify/shopify-app-remix/dist/esm/server/authenticate/admin/scope/client/revoke-scopes.mjs
var REVOKE_SCOPE_MUTATION = `#graphql
mutation AppRevokeAccessScopes($scopes: [String!]!) {
  appRevokeAccessScopes(scopes: $scopes){
    revoked {
      handle
    }
    userErrors {
      field
      message
    }
  }
}`;
async function revokeScopes(admin, scopes) {
  const revokeScopesResult = await admin.graphql(REVOKE_SCOPE_MUTATION, {
    variables: {
      scopes
    }
  });
  const resultContent = await revokeScopesResult.json();
  return resultContent.data.appRevokeAccessScopes;
}

// node_modules/@shopify/shopify-app-remix/dist/esm/server/authenticate/admin/scope/revoke.mjs
function revokeScopesFactory(params, session, admin) {
  return async function revoke(scopes) {
    var _a;
    const { logger } = params;
    await validateScopes(scopes);
    logger.debug("Revoke scopes: ", {
      shop: session.shop,
      scopes
    });
    const revokeScopesResult = await revokeScopes(admin, scopes);
    if (((_a = revokeScopesResult.userErrors) == null ? void 0 : _a.length) > 0) {
      logger.error("Failed to revoke scopes: ", {
        shop: session.shop,
        errors: revokeScopesResult.userErrors
      });
      throw new Response(JSON.stringify(revokeScopesResult.userErrors), {
        status: 422,
        headers: {
          "Content-Type": "application/json"
        }
      });
    }
    return {
      revoked: revokeScopesResult.revoked.map((scope) => scope.handle)
    };
  };
}
async function validateScopes(scopes) {
  if (!scopes || scopes.length === 0) {
    throw new Response("No scopes provided", { status: 400 });
  }
}

// node_modules/@shopify/shopify-app-remix/dist/esm/server/authenticate/admin/scope/factory.mjs
function scopesApiFactory(params, session, admin) {
  return {
    query: queryScopesFactory(params, session, admin),
    request: requestScopesFactory(params, session, admin),
    revoke: revokeScopesFactory(params, session, admin)
  };
}

// node_modules/@shopify/shopify-app-remix/dist/esm/server/authenticate/admin/authenticate.mjs
function authStrategyFactory({ strategy, ...params }) {
  const { api, logger, config } = params;
  async function respondToBouncePageRequest(request) {
    const url = new URL(request.url);
    if (url.pathname === config.auth.patchSessionTokenPath) {
      logger.debug("Rendering bounce page", {
        shop: getShopFromRequest(request)
      });
      throw renderAppBridge({ config }, request);
    }
  }
  async function respondToExitIframeRequest(request) {
    const url = new URL(request.url);
    if (url.pathname === config.auth.exitIframePath) {
      const destination = url.searchParams.get("exitIframe");
      logger.debug("Rendering exit iframe page", {
        shop: getShopFromRequest(request),
        destination
      });
      throw renderAppBridge({ config }, request, { url: destination });
    }
  }
  function createContext(request, session, authStrategy, sessionToken) {
    let context = {
      admin: createAdminApiContext(session, params, authStrategy.handleClientError(request)),
      billing: {
        require: requireBillingFactory(params, request, session),
        check: checkBillingFactory(params, request, session),
        request: requestBillingFactory(params, request, session),
        cancel: cancelBillingFactory(params, request, session),
        createUsageRecord: createUsageRecordFactory(params, request, session),
        updateUsageCappedAmount: updateUsageCappedAmountFactory(params, request, session)
      },
      session,
      cors: ensureCORSHeadersFactory(params, request)
    };
    context = addEmbeddedFeatures(context, request, session, sessionToken);
    context = addScopesFeatures(context);
    return context;
  }
  function addEmbeddedFeatures(context, request, session, sessionToken) {
    if (config.isEmbeddedApp) {
      return {
        ...context,
        sessionToken,
        redirect: redirectFactory(params, request, session.shop)
      };
    }
    return context;
  }
  function addScopesFeatures(context) {
    return {
      ...context,
      scopes: scopesApiFactory(params, context.session, context.admin)
    };
  }
  return async function authenticateAdmin(request) {
    try {
      respondToBotRequest(params, request);
      respondToOptionsRequest(params, request);
      await respondToBouncePageRequest(request);
      await respondToExitIframeRequest(request);
      await strategy.respondToOAuthRequests(request);
      if (!getSessionTokenHeader(request)) {
        validateShopAndHostParams(params, request);
        await ensureAppIsEmbeddedIfRequired(params, request);
        await ensureSessionTokenSearchParamIfRequired(params, request);
      }
      logger.info("Authenticating admin request", {
        shop: getShopFromRequest(request)
      });
      const { payload, shop, sessionId, sessionToken } = await getSessionTokenContext(params, request);
      logger.debug("Loading session from storage", { shop, sessionId });
      const existingSession = sessionId ? await config.sessionStorage.loadSession(sessionId) : void 0;
      const session = await strategy.authenticate(request, {
        session: existingSession,
        sessionToken,
        shop
      });
      return createContext(request, session, strategy, payload);
    } catch (errorOrResponse) {
      if (errorOrResponse instanceof Response) {
        logger.debug("Authenticate returned a response", {
          shop: getShopFromRequest(request)
        });
        ensureCORSHeadersFactory(params, request)(errorOrResponse);
      }
      throw errorOrResponse;
    }
  };
}
async function getSessionTokenContext(params, request) {
  const { api, config, logger } = params;
  const headerSessionToken = getSessionTokenHeader(request);
  const searchParamSessionToken = getSessionTokenFromUrlParam(request);
  const sessionToken = headerSessionToken || searchParamSessionToken;
  logger.debug("Attempting to authenticate session token", {
    shop: getShopFromRequest(request),
    sessionToken: JSON.stringify({
      header: headerSessionToken,
      search: searchParamSessionToken
    })
  });
  if (config.isEmbeddedApp) {
    const payload = await validateSessionToken(params, request, sessionToken);
    const dest = new URL(payload.dest);
    const shop2 = dest.hostname;
    logger.debug("Session token is valid - authenticated", { shop: shop2, payload });
    const sessionId2 = config.useOnlineTokens ? api.session.getJwtSessionId(shop2, payload.sub) : api.session.getOfflineId(shop2);
    return { shop: shop2, payload, sessionId: sessionId2, sessionToken };
  }
  const url = new URL(request.url);
  const shop = url.searchParams.get("shop");
  const sessionId = await api.session.getCurrentId({
    isOnline: config.useOnlineTokens,
    rawRequest: request
  });
  return { shop, sessionId, payload: void 0, sessionToken };
}

// node_modules/@shopify/shopify-app-remix/dist/esm/server/authenticate/webhooks/authenticate.mjs
init_esm();

// node_modules/@shopify/shopify-app-remix/dist/esm/server/authenticate/admin/helpers/handle-client-error.mjs
function handleClientErrorFactory({ request, onError }) {
  return async function handleClientError({ error, params, session }) {
    if (error instanceof HttpResponseError !== true) {
      params.logger.debug(`Got a response error from the API: ${error.message}`, { shop: session.shop });
      throw error;
    }
    params.logger.debug(`Got an HTTP response error from the API: ${error.message}`, {
      shop: session.shop,
      code: error.response.code,
      statusText: error.response.statusText,
      body: JSON.stringify(error.response.body)
    });
    if (onError) {
      await onError({ request, session, error });
    }
    throw new Response(JSON.stringify(error.response.body), {
      status: error.response.code,
      headers: {
        "Content-Type": error.response.headers["Content-Type"]
      }
    });
  };
}

// node_modules/@shopify/shopify-app-remix/dist/esm/server/authenticate/helpers/create-or-load-offline-session.mjs
async function createOrLoadOfflineSession(shop, { api, config, logger }) {
  if (config.distribution === AppDistribution.ShopifyAdmin) {
    logger.debug("Creating custom app session from configured access token", {
      shop
    });
    return api.session.customAppSession(shop);
  } else {
    logger.debug("Loading offline session from session storage", { shop });
    const offlineSessionId = api.session.getOfflineId(shop);
    const session = await config.sessionStorage.loadSession(offlineSessionId);
    return session;
  }
}

// node_modules/@shopify/shopify-app-remix/dist/esm/server/authenticate/webhooks/authenticate.mjs
function authenticateWebhookFactory(params) {
  const { api, logger } = params;
  return async function authenticate(request) {
    if (request.method !== "POST") {
      logger.debug("Received a non-POST request for a webhook. Only POST requests are allowed.", { url: request.url, method: request.method });
      throw new Response(void 0, {
        status: 405,
        statusText: "Method not allowed"
      });
    }
    const rawBody = await request.text();
    const check = await api.webhooks.validate({
      rawBody,
      rawRequest: request
    });
    if (!check.valid) {
      if (check.reason === WebhookValidationErrorReason.InvalidHmac) {
        logger.debug("Webhook HMAC validation failed", check);
        throw new Response(void 0, {
          status: 401,
          statusText: "Unauthorized"
        });
      } else {
        logger.debug("Webhook validation failed", check);
        throw new Response(void 0, { status: 400, statusText: "Bad Request" });
      }
    }
    const session = await createOrLoadOfflineSession(check.domain, params);
    const webhookContext = {
      apiVersion: check.apiVersion,
      shop: check.domain,
      topic: check.topic,
      webhookId: check.webhookId,
      payload: JSON.parse(rawBody),
      subTopic: check.subTopic || void 0,
      session: void 0,
      admin: void 0
    };
    if (!session) {
      return webhookContext;
    }
    const admin = adminClientFactory({
      params,
      session,
      handleClientError: handleClientErrorFactory({ request })
    });
    return {
      ...webhookContext,
      session,
      admin
    };
  };
}

// node_modules/@shopify/shopify-app-remix/dist/esm/server/override-logger.mjs
var import_semver = __toESM(require_semver2(), 1);
function overrideLogger(logger) {
  const baseContext = { package: "shopify-app" };
  const warningFunction = (message, context = {}) => logger.warning(message, { ...baseContext, ...context });
  function deprecated(warningFunction2) {
    return function(version, message) {
      if (import_semver.default.gte(SHOPIFY_REMIX_LIBRARY_VERSION, version)) {
        throw new FeatureDeprecatedError(`Feature was deprecated in version ${version}`);
      }
      return warningFunction2(`[Deprecated | ${version}] ${message}`);
    };
  }
  return {
    ...logger,
    log: (severity, message, context = {}) => logger.log(severity, message, { ...baseContext, ...context }),
    debug: (message, context = {}) => logger.debug(message, { ...baseContext, ...context }),
    info: (message, context = {}) => logger.info(message, { ...baseContext, ...context }),
    warning: warningFunction,
    error: (message, context = {}) => logger.error(message, { ...baseContext, ...context }),
    deprecated: deprecated(warningFunction)
  };
}

// node_modules/@shopify/shopify-app-remix/dist/esm/server/shopify-app.mjs
init_esm();

// node_modules/@shopify/shopify-app-remix/dist/esm/server/authenticate/login/login.mjs
init_esm();
function loginFactory(params) {
  const { api, config, logger } = params;
  return async function login(request) {
    const url = new URL(request.url);
    const shopParam = url.searchParams.get("shop");
    if (request.method === "GET" && !shopParam) {
      return {};
    }
    const shop = shopParam || (await request.formData()).get("shop");
    if (!shop) {
      logger.debug("Missing shop parameter", { shop });
      return { shop: LoginErrorType.MissingShop };
    }
    const shopWithoutProtocol = shop.replace(/^https?:\/\//, "").replace(/\/$/, "");
    const shopWithDomain = (shop == null ? void 0 : shop.indexOf(".")) === -1 ? `${shopWithoutProtocol}.myshopify.com` : shopWithoutProtocol;
    const sanitizedShop = api.utils.sanitizeShop(shopWithDomain);
    if (!sanitizedShop) {
      logger.debug("Invalid shop parameter", { shop });
      return { shop: LoginErrorType.InvalidShop };
    }
    const authPath = `${config.appUrl}${config.auth.path}?shop=${sanitizedShop}`;
    const adminPath = api.utils.legacyUrlToShopAdminUrl(sanitizedShop);
    const installPath = `https://${adminPath}/oauth/install?client_id=${config.apiKey}`;
    const shouldInstall = config.isEmbeddedApp && config.future.unstable_newEmbeddedAuthStrategy;
    const redirectUrl = shouldInstall ? installPath : authPath;
    logger.info(`Redirecting login request to ${redirectUrl}`, {
      shop: sanitizedShop
    });
    throw redirect(redirectUrl);
  };
}

// node_modules/@shopify/shopify-app-remix/dist/esm/server/errors.mjs
var SessionNotFoundError = class extends ShopifyError {
};

// node_modules/@shopify/shopify-app-remix/dist/esm/server/unauthenticated/admin/factory.mjs
function unauthenticatedAdminContextFactory(params) {
  return async (shop) => {
    const session = await createOrLoadOfflineSession(shop, params);
    if (!session) {
      throw new SessionNotFoundError(`Could not find a session for shop ${shop} when creating unauthenticated admin context`);
    }
    return {
      session,
      admin: adminClientFactory({ params, session })
    };
  };
}

// node_modules/@shopify/shopify-app-remix/dist/esm/server/authenticate/public/extension/authenticate.mjs
init_esm();
function authenticateExtensionFactory(params, requestType) {
  return async function authenticateExtension(request, options = {}) {
    const { logger } = params;
    const corsHeaders = options.corsHeaders ?? [];
    respondToBotRequest(params, request);
    respondToOptionsRequest(params, request, corsHeaders);
    const sessionTokenHeader = getSessionTokenHeader(request);
    logger.info(`Authenticating ${requestType} request`, {
      shop: getShopFromRequest(request)
    });
    if (!sessionTokenHeader) {
      logger.debug("Request did not contain a session token", {
        shop: getShopFromRequest(request)
      });
      throw new Response(void 0, {
        status: 401,
        statusText: "Unauthorized"
      });
    }
    return {
      sessionToken: await validateSessionToken(params, request, sessionTokenHeader, { checkAudience: false, retryRequest: false }),
      cors: ensureCORSHeadersFactory(params, request, corsHeaders)
    };
  };
}

// node_modules/@shopify/shopify-app-remix/dist/esm/server/authenticate/public/checkout/authenticate.mjs
function authenticateCheckoutFactory(params) {
  return authenticateExtensionFactory(params, "checkout");
}

// node_modules/@shopify/shopify-app-remix/dist/esm/server/clients/storefront/factory.mjs
function storefrontClientFactory({ params, session }) {
  const { api } = params;
  return {
    graphql: async (query, options = {}) => {
      const client = new api.clients.Storefront({
        session,
        apiVersion: options.apiVersion
      });
      const apiResponse = await client.request(query, {
        variables: options == null ? void 0 : options.variables,
        retries: (options == null ? void 0 : options.tries) ? options.tries - 1 : 0,
        headers: options == null ? void 0 : options.headers
      });
      return new Response(JSON.stringify(apiResponse));
    }
  };
}

// node_modules/@shopify/shopify-app-remix/dist/esm/server/authenticate/public/appProxy/authenticate.mjs
function authenticateAppProxyFactory(params) {
  const { api, config, logger } = params;
  return async function authenticate(request) {
    const url = new URL(request.url);
    const shop = url.searchParams.get("shop");
    logger.info("Authenticating app proxy request", { shop });
    if (!await validateAppProxyHmac(params, url)) {
      logger.info("App proxy request has invalid signature", { shop });
      throw new Response(void 0, {
        status: 400,
        statusText: "Bad Request"
      });
    }
    const sessionId = api.session.getOfflineId(shop);
    const session = await config.sessionStorage.loadSession(sessionId);
    if (!session) {
      logger.debug("Could not find offline session, returning empty context", {
        shop,
        ...Object.fromEntries(url.searchParams.entries())
      });
      const context2 = {
        liquid,
        session: void 0,
        admin: void 0,
        storefront: void 0
      };
      return context2;
    }
    const context = {
      liquid,
      session,
      admin: adminClientFactory({ params, session }),
      storefront: storefrontClientFactory({ params, session })
    };
    return context;
  };
}
var liquid = (body, initAndOptions) => {
  const processedBody = processLiquidBody(body);
  if (typeof initAndOptions !== "object") {
    return new Response(processedBody, {
      status: initAndOptions || 200,
      headers: {
        "Content-Type": "application/liquid"
      }
    });
  }
  const { layout, ...responseInit } = initAndOptions || {};
  const responseBody = layout === false ? `{% layout none %} ${processedBody}` : processedBody;
  const headers = new Headers(responseInit.headers);
  headers.set("Content-Type", "application/liquid");
  return new Response(responseBody, {
    ...responseInit,
    headers
  });
};
async function validateAppProxyHmac(params, url) {
  const { api, logger } = params;
  try {
    let searchParams = new URLSearchParams(url.search);
    if (!searchParams.get("index")) {
      searchParams.delete("index");
    }
    let isValid = await api.utils.validateHmac(Object.fromEntries(searchParams.entries()), { signator: "appProxy" });
    if (!isValid) {
      const cleanPath = url.pathname.replace(/^\//, "").replace(/\/$/, "").replaceAll("/", ".");
      const data = `routes%2F${cleanPath}`;
      searchParams = new URLSearchParams(`?_data=${data}&${searchParams.toString().replace(/^\?/, "")}`);
      isValid = await api.utils.validateHmac(Object.fromEntries(searchParams.entries()), { signator: "appProxy" });
      if (!isValid) {
        const searchParams2 = new URLSearchParams(`?_data=${data}._index&${url.search.replace(/^\?/, "")}`);
        isValid = await api.utils.validateHmac(Object.fromEntries(searchParams2.entries()), { signator: "appProxy" });
      }
    }
    return isValid;
  } catch (error) {
    const shop = url.searchParams.get("shop");
    logger.info(error.message, { shop });
    throw new Response(void 0, { status: 400, statusText: "Bad Request" });
  }
}
function processLiquidBody(body) {
  return body.replaceAll(/<(form[^>]+)action="(\/[^"?]+)(\?[^"]+)?">/g, '<$1action="$2/$3">').replaceAll(/<(a[^>]+)href="(\/[^"?]+)(\?[^"]+)?">/g, '<$1href="$2/$3">');
}

// node_modules/@shopify/shopify-app-remix/dist/esm/server/authenticate/public/customer-account/authenticate.mjs
function authenticateCustomerAccountFactory(params) {
  return authenticateExtensionFactory(params, "customer account");
}

// node_modules/@shopify/shopify-app-remix/dist/esm/server/authenticate/public/pos/authenticate.mjs
function authenticatePOSFactory(params) {
  return authenticateExtensionFactory(params, "pos");
}

// node_modules/@shopify/shopify-app-remix/dist/esm/server/authenticate/public/factory.mjs
function authenticatePublicFactory(params) {
  const authenticateCheckout = authenticateCheckoutFactory(params);
  const authenticateAppProxy = authenticateAppProxyFactory(params);
  const authenticateCustomerAccount = authenticateCustomerAccountFactory(params);
  const authenticatePOS = authenticatePOSFactory(params);
  const context = {
    checkout: authenticateCheckout,
    appProxy: authenticateAppProxy,
    customerAccount: authenticateCustomerAccount,
    pos: authenticatePOS
  };
  return context;
}

// node_modules/@shopify/shopify-app-remix/dist/esm/server/unauthenticated/storefront/factory.mjs
function unauthenticatedStorefrontContextFactory(params) {
  return async (shop) => {
    const session = await createOrLoadOfflineSession(shop, params);
    if (!session) {
      throw new SessionNotFoundError(`Could not find a session for shop ${shop} when creating unauthenticated storefront context`);
    }
    return {
      session,
      storefront: storefrontClientFactory({ params, session })
    };
  };
}

// node_modules/@shopify/shopify-app-remix/dist/esm/server/authenticate/admin/strategies/auth-code-flow.mjs
init_esm();

// node_modules/@shopify/shopify-app-remix/dist/esm/server/authenticate/admin/helpers/trigger-after-auth-hook.mjs
async function triggerAfterAuthHook(params, session, request, authStrategy) {
  const { config, logger } = params;
  if (config.hooks.afterAuth) {
    logger.info("Running afterAuth hook", { shop: session.shop });
    const admin = createAdminApiContext(session, params, authStrategy.handleClientError(request));
    await config.hooks.afterAuth({
      session,
      admin
    });
  }
}

// node_modules/@shopify/shopify-app-remix/dist/esm/server/authenticate/admin/strategies/auth-code-flow.mjs
var AuthCodeFlowStrategy = class {
  constructor({ api, config, logger }) {
    __publicField(this, "api");
    __publicField(this, "config");
    __publicField(this, "logger");
    this.api = api;
    this.config = config;
    this.logger = logger;
  }
  async respondToOAuthRequests(request) {
    const { api, config } = this;
    const url = new URL(request.url);
    const isAuthRequest = url.pathname === config.auth.path;
    const isAuthCallbackRequest = url.pathname === config.auth.callbackPath;
    if (isAuthRequest || isAuthCallbackRequest) {
      const shop = api.utils.sanitizeShop(url.searchParams.get("shop"));
      if (!shop)
        throw new Response("Shop param is invalid", { status: 400 });
      if (isAuthRequest) {
        throw await this.handleAuthBeginRequest(request, shop);
      } else {
        throw await this.handleAuthCallbackRequest(request, shop);
      }
    }
    if (!getSessionTokenHeader(request)) {
      await this.ensureInstalledOnShop(request);
    }
  }
  async authenticate(request, sessionContext) {
    const { api, config, logger } = this;
    const { shop, session } = sessionContext;
    if (!session) {
      logger.debug("No session found, redirecting to OAuth", { shop });
      await redirectToAuthPage({ config, api }, request, shop);
    } else if (!session.isActive(config.scopes)) {
      logger.debug("Found a session, but it has expired, redirecting to OAuth", { shop });
      await redirectToAuthPage({ config, api }, request, shop);
    }
    logger.debug("Found a valid session", { shop });
    return session;
  }
  handleClientError(request) {
    const { api, config, logger } = this;
    return handleClientErrorFactory({
      request,
      onError: async ({ session, error }) => {
        if (error.response.code === 401) {
          throw await redirectToAuthPage({ api, config }, request, session.shop);
        }
      }
    });
  }
  async ensureInstalledOnShop(request) {
    const { api, config, logger } = this;
    validateShopAndHostParams({ api, config, logger }, request);
    const url = new URL(request.url);
    let shop = url.searchParams.get("shop");
    logger.debug("Ensuring app is installed on shop", { shop });
    if (!await this.hasValidOfflineId(request)) {
      logger.info("Could not find a shop, can't authenticate request");
      throw new Response(void 0, {
        status: 400,
        statusText: "Bad Request"
      });
    }
    const offlineSession = await this.getOfflineSession(request);
    const isEmbedded = url.searchParams.get("embedded") === "1";
    if (!offlineSession) {
      logger.info("Shop hasn't installed app yet, redirecting to OAuth", {
        shop
      });
      if (isEmbedded) {
        redirectWithExitIframe({ api, config }, request, shop);
      } else {
        throw await beginAuth({ api, config }, request, false, shop);
      }
    }
    shop = shop || offlineSession.shop;
    if (config.isEmbeddedApp && !isEmbedded) {
      try {
        logger.debug("Ensuring offline session is valid before embedding", {
          shop
        });
        await this.testSession(offlineSession);
        logger.debug("Offline session is still valid, embedding app", { shop });
      } catch (error) {
        await this.handleInvalidOfflineSession(error, request, shop);
      }
    }
  }
  async handleAuthBeginRequest(request, shop) {
    const { api, config, logger } = this;
    logger.info("Handling OAuth begin request", { shop });
    if (config.isEmbeddedApp && request.headers.get("Sec-Fetch-Dest") === "iframe") {
      logger.debug("Auth request in iframe detected, exiting iframe", { shop });
      throw redirectWithExitIframe({ api, config }, request, shop);
    } else {
      throw await beginAuth({ api, config }, request, false, shop);
    }
  }
  async handleAuthCallbackRequest(request, shop) {
    const { api, config, logger } = this;
    logger.info("Handling OAuth callback request", { shop });
    try {
      const { session, headers: responseHeaders } = await api.auth.callback({
        rawRequest: request
      });
      await config.sessionStorage.storeSession(session);
      if (config.useOnlineTokens && !session.isOnline) {
        logger.info("Requesting online access token for offline session", {
          shop
        });
        await beginAuth({ api, config, logger }, request, true, shop);
      }
      logger.debug("Request is valid, loaded session from OAuth callback", {
        shop: session.shop,
        isOnline: session.isOnline
      });
      await triggerAfterAuthHook({ api, config, logger }, session, request, this);
      throw await redirectToShopifyOrAppRoot(request, { api, config, logger }, responseHeaders);
    } catch (error) {
      if (error instanceof Response)
        throw error;
      throw await this.oauthCallbackError(error, request, shop);
    }
  }
  async getOfflineSession(request) {
    const offlineId = await this.getOfflineSessionId(request);
    return this.config.sessionStorage.loadSession(offlineId);
  }
  async hasValidOfflineId(request) {
    return Boolean(await this.getOfflineSessionId(request));
  }
  async getOfflineSessionId(request) {
    const { api } = this;
    const url = new URL(request.url);
    const shop = url.searchParams.get("shop");
    return shop ? api.session.getOfflineId(shop) : api.session.getCurrentId({ isOnline: false, rawRequest: request });
  }
  async testSession(session) {
    const { api } = this;
    const client = new api.clients.Graphql({
      session
    });
    await client.request(`#graphql
      query shopifyAppShopName {
        shop {
          name
        }
      }
    `);
  }
  async oauthCallbackError(error, request, shop) {
    const { logger } = this;
    logger.error("Error during OAuth callback", { shop, error: error.message });
    if (error instanceof CookieNotFound) {
      return this.handleAuthBeginRequest(request, shop);
    }
    if (error instanceof InvalidHmacError || error instanceof InvalidOAuthError) {
      return new Response(void 0, {
        status: 400,
        statusText: "Invalid OAuth Request"
      });
    }
    return new Response(void 0, {
      status: 500,
      statusText: "Internal Server Error"
    });
  }
  async handleInvalidOfflineSession(error, request, shop) {
    const { api, logger, config } = this;
    if (error instanceof HttpResponseError) {
      if (error.response.code === 401) {
        logger.info("Shop session is no longer valid, redirecting to OAuth", {
          shop
        });
        throw await beginAuth({ api, config }, request, false, shop);
      } else {
        const message = JSON.stringify(error.response.body, null, 2);
        logger.error(`Unexpected error during session validation: ${message}`, {
          shop
        });
        throw new Response(void 0, {
          status: error.response.code,
          statusText: error.response.statusText
        });
      }
    } else if (error instanceof GraphqlQueryError) {
      const context = { shop };
      if (error.response) {
        context.response = JSON.stringify(error.body);
      }
      logger.error(`Unexpected error during session validation: ${error.message}`, context);
      throw new Response(void 0, {
        status: 500,
        statusText: "Internal Server Error"
      });
    }
  }
};

// node_modules/@shopify/shopify-app-remix/dist/esm/server/authenticate/admin/strategies/token-exchange.mjs
init_esm();
var TokenExchangeStrategy = class {
  constructor({ api, config, logger }) {
    __publicField(this, "api");
    __publicField(this, "config");
    __publicField(this, "logger");
    this.api = api;
    this.config = config;
    this.logger = logger;
  }
  async respondToOAuthRequests(_request) {
  }
  async authenticate(request, sessionContext) {
    const { api, config, logger } = this;
    const { shop, session, sessionToken } = sessionContext;
    if (!sessionToken)
      throw new InvalidJwtError();
    if (!session || !session.isActive(void 0)) {
      logger.info("No valid session found", { shop });
      logger.info("Requesting offline access token", { shop });
      const { session: offlineSession } = await this.exchangeToken({
        request,
        sessionToken,
        shop,
        requestedTokenType: RequestedTokenType.OfflineAccessToken
      });
      await config.sessionStorage.storeSession(offlineSession);
      let newSession = offlineSession;
      if (config.useOnlineTokens) {
        logger.info("Requesting online access token", { shop });
        const { session: onlineSession } = await this.exchangeToken({
          request,
          sessionToken,
          shop,
          requestedTokenType: RequestedTokenType.OnlineAccessToken
        });
        await config.sessionStorage.storeSession(onlineSession);
        newSession = onlineSession;
      }
      logger.debug("Request is valid, loaded session from session token", {
        shop: newSession.shop,
        isOnline: newSession.isOnline
      });
      try {
        await this.handleAfterAuthHook({ api, config, logger }, newSession, request, sessionToken);
      } catch (errorOrResponse) {
        if (errorOrResponse instanceof Response) {
          throw errorOrResponse;
        }
        throw new Response(void 0, {
          status: 500,
          statusText: "Internal Server Error"
        });
      }
      return newSession;
    }
    return session;
  }
  handleClientError(request) {
    const { api, config, logger } = this;
    return handleClientErrorFactory({
      request,
      onError: async ({ session, error }) => {
        if (error.response.code === 401) {
          logger.debug("Responding to invalid access token", {
            shop: getShopFromRequest(request)
          });
          await invalidateAccessToken({ config, logger }, session);
          respondToInvalidSessionToken({
            params: { config, api, logger },
            request
          });
        }
      }
    });
  }
  async exchangeToken({ request, shop, sessionToken, requestedTokenType }) {
    var _a;
    const { api, config, logger } = this;
    try {
      return await api.auth.tokenExchange({
        sessionToken,
        shop,
        requestedTokenType
      });
    } catch (error) {
      if (error instanceof InvalidJwtError || error instanceof HttpResponseError && error.response.code === 400 && ((_a = error.response.body) == null ? void 0 : _a.error) === "invalid_subject_token") {
        throw respondToInvalidSessionToken({
          params: { api, config, logger },
          request,
          retryRequest: true
        });
      }
      throw new Response(void 0, {
        status: 500,
        statusText: "Internal Server Error"
      });
    }
  }
  async handleAfterAuthHook(params, session, request, sessionToken) {
    const { config } = params;
    await config.idempotentPromiseHandler.handlePromise({
      promiseFunction: () => {
        return triggerAfterAuthHook(params, session, request, this);
      },
      identifier: sessionToken
    });
  }
};

// node_modules/@shopify/shopify-app-remix/dist/esm/server/authenticate/admin/strategies/merchant-custom-app.mjs
init_esm();
var MerchantCustomAuth = class {
  constructor({ api, config, logger }) {
    __publicField(this, "api");
    __publicField(this, "config");
    __publicField(this, "logger");
    this.api = api;
    this.config = config;
    this.logger = logger;
  }
  async respondToOAuthRequests(request) {
    this.logger.debug("Skipping OAuth request for merchant custom app", {
      shop: getShopFromRequest(request)
    });
  }
  async authenticate(_request, sessionContext) {
    const { shop } = sessionContext;
    this.logger.debug("Building session from configured access token for merchant custom app", { shop });
    const session = this.api.session.customAppSession(shop);
    return session;
  }
  handleClientError(request) {
    return handleClientErrorFactory({
      request,
      onError: async ({ error }) => {
        if (error.response.code === 401) {
          this.logger.info("Request failed with 401. Review your API credentials or generate new tokens. https://shopify.dev/docs/apps/build/authentication-authorization/access-token-types/generate-app-access-tokens-admin#rotating-api-credentials-for-admin-created-apps ");
          throw new ShopifyError("Unauthorized: Access token has been revoked.");
        }
      }
    });
  }
};

// node_modules/@shopify/shopify-app-remix/dist/esm/server/authenticate/helpers/idempotent-promise-handler.mjs
var IDENTIFIER_TTL_MS = 6e4;
var IdempotentPromiseHandler = class {
  constructor() {
    __publicField(this, "identifiers");
    this.identifiers = /* @__PURE__ */ new Map();
  }
  async handlePromise({ promiseFunction, identifier }) {
    try {
      if (this.isPromiseRunnable(identifier)) {
        await promiseFunction();
      }
    } finally {
      this.clearStaleIdentifiers();
    }
    return Promise.resolve();
  }
  isPromiseRunnable(identifier) {
    if (!this.identifiers.has(identifier)) {
      this.identifiers.set(identifier, Date.now());
      return true;
    }
    return false;
  }
  async clearStaleIdentifiers() {
    this.identifiers.forEach((date, identifier, map) => {
      if (Date.now() - date > IDENTIFIER_TTL_MS) {
        map.delete(identifier);
      }
    });
  }
};

// node_modules/@shopify/shopify-app-remix/dist/esm/server/authenticate/flow/authenticate.mjs
function authenticateFlowFactory(params) {
  const { api, config, logger } = params;
  return async function authenticate(request) {
    logger.info("Authenticating flow request");
    if (request.method !== "POST") {
      logger.debug("Received a non-POST request for flow. Only POST requests are allowed.", { url: request.url, method: request.method });
      throw new Response(void 0, {
        status: 405,
        statusText: "Method not allowed"
      });
    }
    const rawBody = await request.text();
    const result = await api.flow.validate({
      rawBody,
      rawRequest: request
    });
    if (!result.valid) {
      logger.error("Received an invalid flow request", { reason: result.reason });
      throw new Response(void 0, {
        status: 400,
        statusText: "Bad Request"
      });
    }
    const payload = JSON.parse(rawBody);
    logger.debug("Flow request is valid, looking for an offline session", {
      shop: payload.shopify_domain
    });
    const sessionId = api.session.getOfflineId(payload.shopify_domain);
    const session = await config.sessionStorage.loadSession(sessionId);
    if (!session) {
      logger.info("Flow request could not find session", {
        shop: payload.shopify_domain
      });
      throw new Response(void 0, {
        status: 400,
        statusText: "Bad Request"
      });
    }
    logger.debug("Found a session for the flow request", { shop: session.shop });
    return {
      session,
      payload,
      admin: adminClientFactory({ params, session })
    };
  };
}

// node_modules/@shopify/shopify-app-remix/dist/esm/server/authenticate/fulfillment-service/authenticate.mjs
init_esm();
function authenticateFulfillmentServiceFactory(params) {
  const { api, logger } = params;
  return async function authenticate(request) {
    logger.info("Authenticating fulfillment service request");
    if (request.method !== "POST") {
      logger.debug("Received a non-POST request for fulfillment service. Only POST requests are allowed.", { url: request.url, method: request.method });
      throw new Response(void 0, {
        status: 405,
        statusText: "Method not allowed"
      });
    }
    const rawBody = await request.text();
    const result = await api.fulfillmentService.validate({
      rawBody,
      rawRequest: request
    });
    if (!result.valid) {
      logger.error("Received an invalid fulfillment service request", {
        reason: result.reason
      });
      throw new Response(void 0, {
        status: 400,
        statusText: "Bad Request"
      });
    }
    const payload = JSON.parse(rawBody);
    const shop = request.headers.get(ShopifyHeader.Domain) || "";
    logger.debug("Fulfillment service request is valid, looking for an offline session", {
      shop
    });
    const session = await createOrLoadOfflineSession(shop, params);
    if (!session) {
      logger.info("Fulfillment service request could not find session", {
        shop
      });
      throw new Response(void 0, {
        status: 400,
        statusText: "Bad Request"
      });
    }
    logger.debug("Found a session for the fulfillment service request", {
      shop
    });
    return {
      session,
      payload,
      admin: adminClientFactory({ params, session })
    };
  };
}

// node_modules/@shopify/shopify-app-remix/dist/esm/server/future/flags.mjs
function logDisabledFutureFlags(config, logger) {
  const logFlag = (flag, message) => logger.info(`Future flag ${flag} is disabled.

  ${message}
`);
  if (!config.future.unstable_newEmbeddedAuthStrategy) {
    logFlag("unstable_newEmbeddedAuthStrategy", "Enable this to use OAuth token exchange instead of auth code to generate API access tokens.\n  Your app must be using Shopify managed install: https://shopify.dev/docs/apps/auth/installation");
  }
}

// node_modules/@shopify/shopify-app-remix/dist/esm/server/shopify-app.mjs
function shopifyApp(appConfig) {
  const api = deriveApi(appConfig);
  const config = deriveConfig(appConfig, api.config);
  const logger = overrideLogger(api.logger);
  if (appConfig.webhooks) {
    api.webhooks.addHandlers(appConfig.webhooks);
  }
  const params = { api, config, logger };
  let strategy;
  if (config.distribution === AppDistribution.ShopifyAdmin) {
    strategy = new MerchantCustomAuth(params);
  } else if (config.future.unstable_newEmbeddedAuthStrategy && config.isEmbeddedApp) {
    strategy = new TokenExchangeStrategy(params);
  } else {
    strategy = new AuthCodeFlowStrategy(params);
  }
  const authStrategy = authStrategyFactory({
    ...params,
    strategy
  });
  const shopify = {
    sessionStorage: config.sessionStorage,
    addDocumentResponseHeaders: addDocumentResponseHeadersFactory(params),
    registerWebhooks: registerWebhooksFactory(params),
    authenticate: {
      admin: authStrategy,
      flow: authenticateFlowFactory(params),
      public: authenticatePublicFactory(params),
      fulfillmentService: authenticateFulfillmentServiceFactory(params),
      webhook: authenticateWebhookFactory(params)
    },
    unauthenticated: {
      admin: unauthenticatedAdminContextFactory(params),
      storefront: unauthenticatedStorefrontContextFactory(params)
    }
  };
  if (isAppStoreApp(shopify, appConfig) || isSingleMerchantApp(shopify, appConfig)) {
    shopify.login = loginFactory(params);
  }
  logDisabledFutureFlags(config, logger);
  return shopify;
}
function isAppStoreApp(_shopify, config) {
  return config.distribution === AppDistribution.AppStore;
}
function isSingleMerchantApp(_shopify, config) {
  return config.distribution === AppDistribution.SingleMerchant;
}
function deriveApi(appConfig) {
  let appUrl;
  try {
    appUrl = new URL(appConfig.appUrl);
  } catch (error) {
    const message = appConfig.appUrl === "" ? `Detected an empty appUrl configuration, please make sure to set the necessary environment variables.
If you're deploying your app, you can find more information at https://shopify.dev/docs/apps/launch/deployment/deploy-web-app/deploy-to-hosting-service#step-4-set-up-environment-variables` : `Invalid appUrl configuration '${appConfig.appUrl}', please provide a valid URL.`;
    throw new ShopifyError(message);
  }
  if (appUrl.hostname === "localhost" && !appUrl.port && process.env.PORT) {
    appUrl.port = process.env.PORT;
  }
  appConfig.appUrl = appUrl.origin;
  let userAgentPrefix = `Shopify Remix Library v${SHOPIFY_REMIX_LIBRARY_VERSION}`;
  if (appConfig.userAgentPrefix) {
    userAgentPrefix = `${appConfig.userAgentPrefix} | ${userAgentPrefix}`;
  }
  return shopifyApi({
    ...appConfig,
    hostName: appUrl.host,
    hostScheme: appUrl.protocol.replace(":", ""),
    userAgentPrefix,
    isEmbeddedApp: appConfig.isEmbeddedApp ?? true,
    apiVersion: appConfig.apiVersion ?? LATEST_API_VERSION,
    isCustomStoreApp: appConfig.distribution === AppDistribution.ShopifyAdmin,
    billing: appConfig.billing,
    future: {
      lineItemBilling: true,
      unstable_managedPricingSupport: true
    },
    _logDisabledFutureFlags: false
  });
}
function deriveConfig(appConfig, apiConfig) {
  if (!appConfig.sessionStorage && appConfig.distribution !== AppDistribution.ShopifyAdmin) {
    throw new ShopifyError("Please provide a valid session storage. Refer to https://github.com/Shopify/shopify-app-js/blob/main/README.md#session-storage-options for options.");
  }
  const authPathPrefix = appConfig.authPathPrefix || "/auth";
  appConfig.distribution = appConfig.distribution ?? AppDistribution.AppStore;
  return {
    ...appConfig,
    ...apiConfig,
    billing: appConfig.billing,
    scopes: apiConfig.scopes,
    idempotentPromiseHandler: new IdempotentPromiseHandler(),
    canUseLoginForm: appConfig.distribution !== AppDistribution.ShopifyAdmin,
    useOnlineTokens: appConfig.useOnlineTokens ?? false,
    hooks: appConfig.hooks ?? {},
    sessionStorage: appConfig.sessionStorage,
    future: appConfig.future ?? {},
    auth: {
      path: authPathPrefix,
      callbackPath: `${authPathPrefix}/callback`,
      patchSessionTokenPath: `${authPathPrefix}/session-token`,
      exitIframePath: `${authPathPrefix}/exit-iframe`,
      loginPath: `${authPathPrefix}/login`
    },
    distribution: appConfig.distribution
  };
}

// node_modules/@shopify/shopify-app-remix/dist/esm/server/index.mjs
setAbstractRuntimeString(() => {
  return `Remix`;
});
export {
  ApiVersion,
  AppDistribution,
  BillingInterval,
  BillingReplacementBehavior,
  DeliveryMethod,
  LATEST_API_VERSION,
  LogSeverity,
  LoginErrorType,
  RELEASE_CANDIDATE_API_VERSION,
  Session,
  SessionNotFoundError,
  boundary,
  shopifyApp
};
//# sourceMappingURL=@shopify_shopify-app-remix_server.js.map
