import { LegacyCard, Page, Tabs, IndexTable, Text, Button, Badge, useIndexResourceState,Modal, Pagination,Select ,IndexFilters,useSetIndexFiltersMode } from '@shopify/polaris';
import { useState, useEffect } from 'react';
import { ImportIcon } from '@shopify/polaris-icons';
import { useLoaderData } from '@remix-run/react';
import { authenticate } from "../shopify.server";
import prisma from "../db.server";
import { json } from "@remix-run/node";
import styles from '../styles/app.products.module.css';
import axios from 'axios';
import wrap from "word-wrap";
// import { log } from 'console';

export const loader = async ({ request }) => {
  const { session } = await authenticate.admin(request);

  const user = await prisma.users.findFirst({
    where: { shopurl: session.shop }
  });

  const user_id = user?.id;

  const amzKey = await prisma.amz_keys.findFirst({
    where: { user_id },
    select: { marketplace_id: true },
  });

  const marketplaceId = amzKey?.marketplace_id ?? null;
  return json({ user, marketplaceId });
};

export default function Products() {
  const { user } = useLoaderData();
  const [products, setProducts] = useState([]);
  const [loading, setLoading] = useState(true);
  const [selectedTab, setSelectedTab] = useState(0);
  const [counts, setCounts] = useState({});
  const [perPageValue, setPerPageValue] = useState("20");
  const [current_page, setCurrentPage] = useState(1);
  const [productData, setproductData] = useState(false);
  const [firstProductNo, setFirstProductNo] = useState(1);
  const [lastProductNo, setLastProductNo] = useState("20");
  const [status, setStatus] = useState("All");
  const userId = user?.id;
  const [totalItems, setTotalItems] = useState(0);
  const [totalProduct, setTotalProduct] = useState(0);

  const [activeModal, setActiveModal] = useState(false);
  const [selectedProduct, setSelectedProduct] = useState(null);
  const [page, setPage] = useState(1);
  const [pageSize, setPageSize] = useState(5);
  const [pagination, setPagination] = useState({ total: 0, totalPages: 1 });
  const [sortSelected, setSortSelected] = useState(["Product desc"]);
  const [queryValue, setQueryValue] = useState("");
 const [countOfProduct, setCountOfProduct] = useState({
    all: 0,
    already_exist: 0,
    ready_to_import: 0,
    import_in_progress: 0,
    imported: 0,
    reimport_in_progress: 0,
    error: 0,
    linked: 0,
  });
  const [query, setQuery] = useState("");
  const { mode, setMode } = useSetIndexFiltersMode();


   const sortOptions = [
    { label: "Product", value: "Product asc", directionLabel: "Ascending" },
    { label: "Product", value: "Product desc", directionLabel: "Descending" },
    { label: "Title", value: "Title asc", directionLabel: "Title asc" },
    { label: "Title", value: "Title desc", directionLabel: "Title desc" },
  ];
  const statusMap = {
    Ready_to_Import: "Ready To Import",
    Import_in_progress: "Import In Progress",
    Imported: "Imported",
    reimport_in_progress: "ReImport In Progress",
    error: "Error",
    Unlinked: "Unlinked",
    linked: "Linked",
  };

  const statusToneMap = {
    Ready_to_Import: "info",
    Import_in_progress: "warning",
    Imported: "success",
    reimport_in_progress: "warning",
    error: "critical",
    Unlinked: "info",
    linked: "success",
  };

    const statusKeyMap = {
    All: "all",
    "Already Exist": "already_exist",
    "Ready To Import": "ready_to_import",
    "Import In Progress": "import_in_progress",
    Imported: "imported",
    "ReImport In Progress": "reimport_in_progress",
    Error: "error",
    Linked: "linked",
  };
  const [itemProducts, setItemProducts] = useState([
    `All`,
    `Ready To Import`,
    "Imported",
    "Import In Progress",
    "ReImport In Progress",
    "Error",
  ]);

  const tabs = itemProducts.map((item, index) => {
    const key = statusKeyMap[item];
    const badgeValue = key ? (countOfProduct[key] ?? 0) : 0;

    return {
      content: item,
      badge: badgeValue,
      index,
      onAction: () => {},
      id: `${item}-${index}`,
      isLocked: index === 0,
      actions: index === 0 ? [] : [],
    };
  });

useEffect(() => {
  fetchproduct('All');
}, [user]);

 const reverseStatusMap = {
    Already_Exist: "Already Exist",
    Ready_to_Import: "Ready to Import",
    Import_in_progress: "Import in progress",
    Imported: "Imported",
    error: "error",
    reimport_in_progress: "reimport in progress",
    linked: "Linked",
  };
const fetchproduct = async(
  status,
  query,
  orderBy,
  parPage = perPageValue,
  page = current_page)=>{
  try {
      setproductData(false);
      setStatus(status);
      let lastpage = ((current_page * page) / current_page) * parPage;
      setLastProductNo(lastpage);
      setFirstProductNo(lastpage - parPage + 1);
      // handleFetchShopifyProductCount();
      const res = await axios.get(`/api/products/`, {
        params: {
          status: status,
          user_id: userId,
          query: query,
          orderBy: orderBy,
          parPage: parPage,
          page: page, 
        },
      });
      console.log("res.data -> ",res);
      
      const productData = res.data.productsWithData;
      setproductData(true);
      setTotalProduct(res.data.totalProduct);
      setTotalItems(res.data.totalCount);
      if (lastProductNo > res.data.totalCount) {
        setLastProductNo(res.data.totalCount);
      }
      const formattedProducts = productData.map((product) => {
        console.log(product);
        
        let firstImage = "";
        try {
           firstImage = product.firstImage.split("|")[0] ?? "";

          // firstImage = images?.image_url || "";
        } catch (e) {
          console.error(
            "Invalid JSON in product_image_data:",
            product.product_image_data,
          );
        }
        console.log("product.status ->>> ",product.status);
        console.log(reverseStatusMap[product.status]);
        
        return {
          id: product.product_id,
          title: wrap(product.title, { width: 70 }),
          status: reverseStatusMap[product.status],
          block: product?.block || 0,
          has_variation: product.has_variation || 0,
          shopifyproductid: product.shopifyproductid || 0,
          etsylistingid: product.etsylistingid || 0,
          image: firstImage,
          variants: product.variants || [],
        };
      });
      setProducts(formattedProducts);
    } catch (error) {
      console.log("error while fetching products :: ", error);
    }
};

 const handleFiltersQueryChange = (value) => {
    console.log(value);
    setQuery(value);
    setQueryValue(value);
    fetchproduct(status, value);
  };

  // const tabs = [
  //   {
  //     id: 'all-products-1',
  //     badge: counts?.all ?? '0',
  //     content: 'All',
  //     status: null,
  //   },
  //   {
  //     id: 'Ready-to-import-2',
  //     badge: counts?.readyToImport ?? '0',
  //     content: 'Ready To Import',
  //     status: 'Ready_to_Import',
  //   },
  //   {
  //     id: 'imported-3',
  //     badge: counts?.imported ?? '0',
  //     content: 'Imported',
  //     status: 'Imported'
  //   },
  //   {
  //     id: 'Import-in-progress-4',
  //     badge: counts?.importInProgress ?? '0',
  //     content: 'Import In Progress',
  //     status: 'Import_in_progress'
  //   },
  // ];

 const handleModalChange = async(product) =>{

          if (activeModal) {
            setActiveModal(false);
            setSelectedProduct(null);
            return;
          }

      if(product){
        try {
          const response = await fetch("/api/productVariant",{
            method: "POST",
            headers: { "Content-Type": "application/json" },
            body: JSON.stringify({product_id: product.product_id})
          });
           const data = await response.json();
           if (data.success) {
            setSelectedProduct({ ...product, variants: data.data });
           } else {
            setSelectedProduct({ ...product, variants: [] });
            console.error("Failed to load variants:", data.message);
           }
        } catch (error) {
          console.error("Error fetching variants:", error);
          setSelectedProduct({ ...product, variants: [] });
        }
      } else{
        setSelectedProduct(null);
      }
      setActiveModal((prev)=> !prev)
    }

  const handleTabChange = (index) => {
    setSelectedTab(index);
  };

  const activeTab = tabs[selectedTab];
  const filteredProducts = activeTab.status
    ? products.filter((p) => p.status === activeTab.status) 
    : products;

 const resourceName = { singular: 'product', plural: 'products' };

const { selectedResources, allResourcesSelected, handleSelectionChange } =
  useIndexResourceState(filteredProducts, {
    resourceIDResolver: (product) => product.product_id.toString(),
  });
   const handleSortChange = (value) => {
    setSortSelected(value);
    // fetchproduct(status, query, value[0], perPageValue);
    console.log(value);
  };
  const handleCancelSearch = () => {
    setQuery("");
    console.log("handleCancelSearch");
    setQueryValue("");
    // fetchproduct(status);
  };

  const rowMarkup = filteredProducts.map((product, index) => (
    <IndexTable.Row
      id={product.product_id}
      key={product.product_id}
      selected={selectedResources.includes(product.product_id)}
      position={index}
      onClick={(e) => e.stopPropagation()}>
      <IndexTable.Cell>
        <img src={product.firstImage} alt="No Image" width={50} />
      </IndexTable.Cell>
      <IndexTable.Cell>
        <div className={styles.titleCell}>{product.title}</div>
      </IndexTable.Cell>
      <IndexTable.Cell><span className={styles.variantLink} onClick={() =>handleModalChange(product)}>
        2
        {/* {product.variants.length} {product.variants.length === 1 ? "variant" : "variants"} */}
      </span></IndexTable.Cell>
      <IndexTable.Cell>
        <Badge tone={statusToneMap[product.status]}>{statusMap[product.status]}</Badge>
      </IndexTable.Cell>
      <IndexTable.Cell>
        <Text variant="bodyMd" as="a" href="#">Open</Text>
      </IndexTable.Cell>
      <IndexTable.Cell>
        <Button variant='primary'>Import On Amazon</Button>
      </IndexTable.Cell>
    </IndexTable.Row>
  ));

  return (
    <>
      <Page
        fullWidth
        title="Amazon Products"
        primaryAction={{ content: "Fetch Amazon Products", icon: ImportIcon }}
      >
          <Modal
            open={activeModal}
            onClose={handleModalChange}
            title="Product Variation List"
            primaryAction={{
              content: 'Close',
              onAction:handleModalChange
            }}
          >
          <Modal.Section>
            <div className={styles.variantTableContainer}>
              <table className={styles.variantTable}>
                <thead>
                  <tr>
                    <th>Title</th>
                    <th>SKU</th>
                    <th >Quantity</th>
                    <th>Price</th>
                    <th>Option1</th>
                    <th>Option2</th>
                    <th>Option3</th>
                  </tr>
                </thead>

                <tbody>
                 {selectedProduct?.variants?.length > 0 ? (
                 selectedProduct.variants.map((variant, index) => (
                  <tr key={variant.id || index}>
                    <td> {variant.title || "Default Title"}</td>
                    <td>{variant.sku || "—"}</td>
                    <td>{variant.quantity ?? "—"}</td>
                    <td>{variant.price ?? "—"}</td>
                    <td>{variant.option1val ?? "—"}</td>
                    <td>{variant.option2val ?? "—"}</td>
                    <td>{variant.option3val ?? "—"}</td>
                  </tr>
                   ))
                 ):(
                  <tr>
                    <td colSpan="7" style={{ textAlign: "center", padding: "8px" }}>
                      No variants found
                    </td>
                  </tr>
                 )}
                </tbody>
              </table>
            </div>
          </Modal.Section>
          </Modal>

        <LegacyCard>
           <IndexFilters
              sortOptions={sortOptions}
              sortSelected={sortSelected}
              queryValue={queryValue}
              queryPlaceholder="Search products"
              onQueryChange={handleFiltersQueryChange}
              onQueryClear={() => setQueryValue("")}
              onSort={handleSortChange}
              primaryAction={null}
              cancelAction={{
                content: "cancel",
                onAction: handleCancelSearch,
              }}
              tabs={tabs}
              selected={selectedTab}
              filters={[]}
              onSelect={(index) => {
                setSelectedTab(index);
                const selectedStatus = itemProducts[index];
                // fetchproduct(selectedStatus);
              }}
              mode={mode}
              setMode={setMode}
              canCreateNewView={false}
            />
          {/* <Tabs tabs={tabs} selected={selectedTab} onSelect={handleTabChange}> */}
              <IndexTable
                resourceName={resourceName}
                itemCount={filteredProducts.length}
                selectedItemsCount={allResourcesSelected ? filteredProducts.length : selectedResources.length}
                onSelectionChange={handleSelectionChange}
                headings={[
                  { title: "Image" },
                  { title: "Title" },
                  { title: "Variations" },
                  { title: "Status" },
                  { title: "View On" },
                  { title: "Action" },
                ]}
                selectable
              >
                {rowMarkup}
              </IndexTable>
          {/* </Tabs> */}
        </LegacyCard>
         <div className={styles.paginationContainer}>
           <Pagination
              onPrevious={''}
              onNext={''}
              hasPrevious={''}
              hasNext={""}
              type="table"
              label={`Total products`}
            />
            <select className={styles.pageSizeSelect}
              value={''}
              defaultValue="5"
              onChange={''}>
              <option value="5">5</option>
              <option value="7">7</option>
              <option value="9">9</option>
            </select>
         </div>
      </Page>
    </>
  );
}
