import { json } from "@remix-run/node";
import prisma from "../db.server";

export const loader = async ({request}) => {
  try {
    const url = new URL(request.url);
    const userId = parseInt(url.searchParams.get("userId"));
    const product_id = url.searchParams.get("productId") || "";
    const productIdArray = product_id.split(',').map(id => id.trim()).filter(id => id !== '');
    console.log("product id array ", productIdArray);
    const userData =  await prisma.users.findFirst({
      where: { id: userId },
    });
    if (!(await userValidate(userData, productIdArray.length))) {
      return json(
        {
          msg: "You have reached your import limit. Please upgrade your plan to import more products.",
        },
        { status: 210 },
      );
    }
    


    return json({ success: true, message: "Product IDs received", data: productIdArray });
  } catch (error) {
    console.error("Count API Error:", error);
    return json({ error: error.message }, { status: 500 });
  }
  async function userValidate(userData, countOfProduct) {
  console.log("user data userValidate    ", userData);
  if (userData.skuconsumed >= userData.skulimit) {
    console.log("return false");
    return false;
  }
  let newSkuconsumed = userData.skuconsumed + countOfProduct;
  await prisma.users.update({
    where: {
      id: userData.id,
    },
    data: {
      skuconsumed: newSkuconsumed,
    },
  });
  return true;
}
};
