import { MigrationOperation, SessionStorageMigrator, SessionStorageMigratorOptions, DBConnection } from './types';
export declare abstract class AbstractMigrationEngine<ConnectionType extends DBConnection, MigratorOptionType extends SessionStorageMigratorOptions> implements SessionStorageMigrator {
    protected options: SessionStorageMigratorOptions;
    protected connection: ConnectionType;
    protected ready: Promise<void>;
    protected migrations: MigrationOperation[];
    constructor(db: ConnectionType, opts: Partial<MigratorOptionType> | undefined, migrations: MigrationOperation[]);
    applyMigrations(databaseReady: Promise<void>): Promise<void>;
    getMigrationList(): MigrationOperation[];
    abstract initMigrationPersistence(): Promise<void>;
    abstract hasMigrationBeenApplied(migrationName: string): Promise<boolean>;
    abstract saveAppliedMigration(migrationName: string): Promise<void>;
}
//# sourceMappingURL=abstract-migration-engine.d.ts.map