import { AbstractMigrationEngine } from './abstract-migration-engine.mjs';
import { defaultRdbmsSessionStorageMigratorOptions } from './types.mjs';

class RdbmsSessionStorageMigrator extends AbstractMigrationEngine {
    constructor(dbConnection, opts = {}, migrations) {
        super(dbConnection, {
            ...defaultRdbmsSessionStorageMigratorOptions,
            ...opts,
        }, migrations);
    }
    async hasMigrationBeenApplied(migrationName) {
        await this.ready;
        const query = `
      SELECT * FROM ${this.options.migrationDBIdentifier}
      WHERE ${this.getOptions().migrationNameColumnName} =
        ${this.connection.getArgumentPlaceholder(1)};
    `;
        const rows = await this.connection.query(query, [migrationName]);
        return rows.length === 1;
    }
    async saveAppliedMigration(migrationName) {
        await this.ready;
        const insert = `
          INSERT INTO ${this.options.migrationDBIdentifier} (${this.getOptions().migrationNameColumnName})
          VALUES(${this.connection.getArgumentPlaceholder(1)});
        `;
        await this.connection.query(insert, [migrationName]);
    }
    getOptions() {
        return this.options;
    }
}

export { RdbmsSessionStorageMigrator };
//# sourceMappingURL=rdbms-session-storage-migrator.mjs.map
