import { LogSeverity, ShopifyRestResources } from '@shopify/shopify-api';
import { SessionStorage } from '@shopify/shopify-app-session-storage';
import { MemorySessionStorage } from '@shopify/shopify-app-session-storage-memory';
import type { AppConfigArg } from '../config-types';
import type { FutureFlagOptions } from '../future/flags';
declare const TEST_CONFIG: {
    readonly apiKey: "testApiKey";
    readonly apiSecretKey: "testApiSecretKey";
    readonly scopes: any;
    readonly appUrl: "https://my-test-app.myshopify.io";
    readonly adminApiAccessToken: "testApiKey";
    readonly privateAppStorefrontAccessToken: "testApiKey";
    readonly logger: {
        readonly level: LogSeverity.Debug;
    };
    readonly sessionStorage: MemorySessionStorage;
    readonly isTesting: true;
};
export declare function testConfig<Overrides extends TestOverridesArg, Future extends FutureFlagOptions>({ future, ...overrides }?: Overrides & {
    future?: Future;
}): TestConfig<Overrides>;
type Modify<Type1, Type2> = {
    [key in keyof Type2 as Type2[key] extends undefined ? never : key]: Type2[key];
} & {
    [key in keyof Type1 as key extends keyof Type2 ? never : key]: Type1[key];
};
type TestOverrides = Partial<Omit<AppConfigArg<ShopifyRestResources, SessionStorage, FutureFlagOptions>, 'future'> & {
    future: Partial<FutureFlagOptions>;
}>;
export type TestOverridesArg = undefined | TestOverrides;
export type TestConfig<Overrides extends TestOverridesArg> = Modify<typeof TEST_CONFIG, Overrides> & {
    future: FutureFlagOptions;
    logger: AppConfigArg['logger'];
};
export {};
//# sourceMappingURL=test-config.d.ts.map