import type { ConfigParams, Shopify, ShopifyRestResources } from '@shopify/shopify-api';
import { AppConfig } from '../config-types';
export interface FutureFlags {
    /**
     * When enabled, embedded apps will fetch access tokens via [token exchange](https://shopify.dev/docs/apps/auth/get-access-tokens/token-exchange).
     * This assumes the app has scopes declared for [Shopify managing installation](https://shopify.dev/docs/apps/auth/installation#shopify-managed-installation).
     *
     * Learn more about this [new embedded app auth strategy](https://shopify.dev/docs/api/shopify-app-remix#embedded-auth-strategy).
     *
     * @default false
     */
    unstable_newEmbeddedAuthStrategy?: boolean;
    /**
     * When enabled, methods for interacting with the admin REST API will not be returned.
     *
     * This affects:
     *
     * * `authenticate.admin(request)`
     * * `authenticate.webhook(request)`
     * * `authenticate.flow(request)`
     * * `authenticate.appProxy(request)`
     * * `authenticate.fulfillmentService(request)`
     * * `unauthenticated.admin(shop)`
     *
     * In a future release we will remove REST from the package completely.
     *
     * Please see: [https://www.shopify.com/ca/partners/blog/all-in-on-graphql](https://www.shopify.com/ca/partners/blog/all-in-on-graphql)
     *
     * @default false
     */
    removeRest?: boolean;
}
export interface ApiFutureFlags<_Future extends FutureFlagOptions> {
    lineItemBilling: true;
    unstable_managedPricingSupport: true;
}
export type ApiConfigWithFutureFlags<Future extends FutureFlagOptions> = ConfigParams<ShopifyRestResources, ApiFutureFlags<Future>>;
export type FutureFlagOptions = FutureFlags | undefined;
export type FeatureEnabled<Future extends FutureFlagOptions, Flag extends keyof FutureFlags> = Future extends FutureFlags ? Future[Flag] extends true ? true : false : false;
export declare function logDisabledFutureFlags(config: AppConfig, logger: Shopify['logger']): void;
//# sourceMappingURL=flags.d.ts.map