import { JwtPayload, ShopifyRestResources } from '@shopify/shopify-api';
import type { BasicParams } from '../../types';
import type { AppConfigArg } from '../../config-types';
import type { AuthenticateAdmin } from './types';
import { AuthorizationStrategy } from './strategies/types';
export interface SessionTokenContext {
    shop: string;
    sessionId?: string;
    sessionToken?: string;
    payload?: JwtPayload;
}
interface AuthStrategyParams extends BasicParams {
    strategy: AuthorizationStrategy;
}
export declare function authStrategyFactory<ConfigArg extends AppConfigArg, Resources extends ShopifyRestResources = ShopifyRestResources>({ strategy, ...params }: AuthStrategyParams): AuthenticateAdmin<ConfigArg, Resources>;
export {};
//# sourceMappingURL=authenticate.d.ts.map