'use strict';

var shopifyApi = require('@shopify/shopify-api');
var memory = require('../../session-storage/shopify-app-session-storage-memory/dist/esm/memory.js');
var testHelpers = require('@shopify/shopify-api/test-helpers');

const TEST_CONFIG = {
    apiKey: testHelpers.API_KEY,
    apiSecretKey: testHelpers.API_SECRET_KEY,
    scopes: ['testScope'],
    appUrl: testHelpers.APP_URL,
    adminApiAccessToken: testHelpers.API_KEY,
    privateAppStorefrontAccessToken: testHelpers.API_KEY,
    logger: {
        level: shopifyApi.LogSeverity.Debug,
    },
    sessionStorage: new memory.MemorySessionStorage(),
    isTesting: true,
};
function testConfig({ future, ...overrides } = {}) {
    return {
        ...TEST_CONFIG,
        ...overrides,
        logger: {
            ...TEST_CONFIG.logger,
            ...overrides.logger,
        },
        future,
    };
}

exports.testConfig = testConfig;
//# sourceMappingURL=test-config.js.map
