'use strict';

var respondToInvalidSessionToken = require('./respond-to-invalid-session-token.js');
var getShopFromRequest = require('./get-shop-from-request.js');

async function validateSessionToken(params, request, token, { checkAudience = true, retryRequest = true } = {}) {
    const { api, logger } = params;
    const shop = getShopFromRequest.getShopFromRequest(request);
    logger.debug('Validating session token', { shop });
    try {
        const payload = await api.session.decodeSessionToken(token, {
            checkAudience,
        });
        logger.debug('Session token is valid - validated', {
            shop,
            payload: JSON.stringify(payload),
        });
        return payload;
    }
    catch (error) {
        logger.debug(`Failed to validate session token: ${error.message}`, {
            shop,
        });
        throw respondToInvalidSessionToken.respondToInvalidSessionToken({ params, request, retryRequest });
    }
}

exports.validateSessionToken = validateSessionToken;
//# sourceMappingURL=validate-session-token.js.map
