'use strict';

var ensureCorsHeaders = require('./ensure-cors-headers.js');

function respondToOptionsRequest(params, request, corsHeaders) {
    if (request.method === 'OPTIONS') {
        const ensureCORSHeaders = ensureCorsHeaders.ensureCORSHeadersFactory(params, request, corsHeaders);
        throw ensureCORSHeaders(new Response(null, {
            status: 204,
            headers: {
                'Access-Control-Max-Age': '7200',
            },
        }));
    }
}

exports.respondToOptionsRequest = respondToOptionsRequest;
//# sourceMappingURL=respond-to-options-request.js.map
