'use strict';

var redirectToBouncePage = require('../admin/helpers/redirect-to-bounce-page.js');
var _const = require('../const.js');

function respondToInvalidSessionToken({ params, request, retryRequest = false, }) {
    const { api, logger, config } = params;
    const isDocumentRequest = !request.headers.get('authorization');
    if (isDocumentRequest) {
        return redirectToBouncePage.redirectToBouncePage({ config }, new URL(request.url));
    }
    throw new Response(undefined, {
        status: 401,
        statusText: 'Unauthorized',
        headers: retryRequest ? _const.RETRY_INVALID_SESSION_HEADER : {},
    });
}

exports.respondToInvalidSessionToken = respondToInvalidSessionToken;
//# sourceMappingURL=respond-to-invalid-session-token.js.map
