'use strict';

var serverRuntime = require('@remix-run/server-runtime');
var redirectWithAppBridgeHeaders = require('./redirect-with-app-bridge-headers.js');

async function redirectToInstallPage(params, shop, optionalScopes = []) {
    const installUrl = buildInstallUrl(params, shop, optionalScopes);
    if (params.config.isEmbeddedApp) {
        throw redirectWithAppBridgeHeaders.redirectWithAppBridgeHeaders(installUrl);
    }
    else {
        throw serverRuntime.redirect(installUrl);
    }
}
function buildInstallUrl(params, shop, optionalScopes = []) {
    const baseInstallUrl = buildBaseInstallUrl(params, shop);
    baseInstallUrl.search = buildParamsInstallUrl(params, optionalScopes).toString();
    return baseInstallUrl.href;
}
function buildBaseInstallUrl({ api }, shop) {
    const cleanShop = api.utils.sanitizeShop(shop, true);
    return new URL(`https://${cleanShop}/admin/oauth/install`);
}
function buildParamsInstallUrl({ config }, optionalScopes = []) {
    const optionalScopesParam = optionalScopes && optionalScopes.length > 0
        ? { optional_scopes: optionalScopes.join(',') }
        : undefined;
    const query = {
        client_id: config.apiKey,
        scope: config.scopes?.toString() || '',
        ...optionalScopesParam,
    };
    return new URLSearchParams(query);
}

exports.redirectToInstallPage = redirectToInstallPage;
//# sourceMappingURL=redirect-to-install-page.js.map
