'use strict';

require('../crypto/crypto.js');
require('../crypto/types.js');

function isOK(resp) {
    // https://fetch.spec.whatwg.org/#ok-status
    return resp.statusCode >= 200 && resp.statusCode <= 299;
}
// We ignore mutable export linting errors because we explicitly want these abstract functions to be overwritten.
// eslint-disable-next-line import/no-mutable-exports
exports.abstractFetch = () => {
    throw new Error("Missing adapter implementation for 'abstractFetch' - make sure to import the appropriate adapter for your platform");
};
function setAbstractFetchFunc(func) {
    exports.abstractFetch = func;
}
// eslint-disable-next-line import/no-mutable-exports
exports.abstractConvertRequest = () => {
    throw new Error("Missing adapter implementation for 'abstractConvertRequest' - make sure to import the appropriate adapter for your platform");
};
function setAbstractConvertRequestFunc(func) {
    exports.abstractConvertRequest = func;
}
// By default we just return an empty NormalizedResponse because not all adapters will need to convert an incoming response
// eslint-disable-next-line import/no-mutable-exports
exports.abstractConvertIncomingResponse = () => Promise.resolve({});
function setAbstractConvertIncomingResponseFunc(func) {
    exports.abstractConvertIncomingResponse = func;
}
// eslint-disable-next-line import/no-mutable-exports
exports.abstractConvertResponse = () => {
    throw new Error("Missing adapter implementation for 'abstractConvertResponse' - make sure to import the appropriate adapter for your platform");
};
function setAbstractConvertResponseFunc(func) {
    exports.abstractConvertResponse = func;
}
// eslint-disable-next-line import/no-mutable-exports
exports.abstractConvertHeaders = () => {
    throw new Error("Missing adapter implementation for 'abstractConvertHeaders' - make sure to import the appropriate adapter for your platform");
};
function setAbstractConvertHeadersFunc(func) {
    exports.abstractConvertHeaders = func;
}

exports.isOK = isOK;
exports.setAbstractConvertHeadersFunc = setAbstractConvertHeadersFunc;
exports.setAbstractConvertIncomingResponseFunc = setAbstractConvertIncomingResponseFunc;
exports.setAbstractConvertRequestFunc = setAbstractConvertRequestFunc;
exports.setAbstractConvertResponseFunc = setAbstractConvertResponseFunc;
exports.setAbstractFetchFunc = setAbstractFetchFunc;
//# sourceMappingURL=index.js.map
