import { type RouteConfigEntry } from "@remix-run/route-config";
/**
 * Creates route config from the file system that matches [Remix's default file
 * conventions](https://remix.run/docs/en/v2/file-conventions/routes), for
 * use within `routes.ts`.
 */
export declare function flatRoutes(options?: {
    /**
     * An array of [minimatch](https://www.npmjs.com/package/minimatch) globs that match files to ignore.
     * Defaults to `[]`.
     */
    ignoredRouteFiles?: string[];
    /**
     * The directory containing file system routes, relative to the app directory.
     * Defaults to `"./routes"`.
     */
    rootDirectory?: string;
}): Promise<RouteConfigEntry[]>;
