/**
 * Given a Path and a key, return a new Path containing the new key.
 */
export function addPath(prev, key, typename) {
    return { prev, key, typename };
}
/**
 * Given a Path, return an Array of the path keys.
 */
export function pathToArray(path) {
    const flattened = [];
    let curr = path;
    while (curr) {
        flattened.push(curr.key);
        curr = curr.prev;
    }
    return flattened.reverse();
}
/**
 * Build a string describing the path.
 */
export function printPathArray(path) {
    return path
        .map(key => (typeof key === 'number' ? '[' + key.toString() + ']' : '.' + key))
        .join('');
}
