import { authenticate } from "../shopify.server";
import prisma from "../db.server";
import { json } from "@remix-run/node";

export const loader = async ({ request }) => {
  const {session} = await authenticate.admin(request);

  console.log(session);

  const user = await prisma.users.findFirst({
    where:{
      shopurl:session.shop
    }
  });
  
  return json({ plan: user.plan});
};

export const action = async ({ request }) => {
  const { session } = await authenticate.admin(request);
  const body = await request.json();
  const { plan , userId } = body;

  console.log(userId);

  await prisma.users.update({
    where: {id: userId},
    data: { plan }
  });

  return json({ success: true, plan });
};