import { json } from "@remix-run/node";
import prisma from "../db.server";

export const loader = async ({request}) => {
  try {
    const url = new URL(request.url);
    const userId = url.searchParams.get("userId");

    const products = await prisma.products.findMany({
       where:{user_id:Number(userId)},
      select: {
        product_id: true,
        title: true,
        status: true,
        description: true,
        created_at:true,
      },
      orderBy: { created_at: "desc" },
    });

    const productIds = products.map((p) => p.product_id);

    const variants = await prisma.product_variants.findMany({
      where: { product_id: { in: productIds } },
      select: {
        id: true,
        product_id: true,
        price: true,
        asin:true,
        sku: true,
        quantity: true,
        option1val:true,
        option2val:true,
        option3val:true,
      },
    });

    const asins = variants.map(v => v.asin);

     const images = await prisma.pc_images.findMany({
      where: { 
        asin: { in: asins,}
      },
      select: {
        asin: true,
        imageArr: true,
      },
    });

    const productsWithData = products.map((p) => {
      const productVariants = variants.filter(v => v.product_id === p.product_id);

      const firstVariant = productVariants[0]; 
      const matchedImages = images.find(img => img.asin === firstVariant?.asin);

      const firstImage = matchedImages?.imageArr ?? null;

      return {
        ...p,
        variants: productVariants,
        firstImage,
      };
    });

    return json({ products: productsWithData });
  } catch (error) {
    console.error("Loader error:", error);
    return json({ error: error.message }, { status: 500 });
  }
};
