import { json } from "@remix-run/node";
import prisma from "../db.server";

export const loader = async ({request}) => {
  try {
    const url = new URL(request.url);
    const userId = parseInt(url.searchParams.get("user_id"));
    const status = url.searchParams.get("status") || null;

    const whereClause = {
      user_id: userId,
      ...(status ? { status } : {})
    };

    const [all, readyToImport, imported, importInProgress] = await Promise.all([
      prisma.products.count({ where: { user_id: userId } }),
      prisma.products.count({ where: { status: "Ready_to_Import",user_id: userId } }),
      prisma.products.count({ where: { status: "Imported", user_id: userId } }),
      prisma.products.count({ where: { status: "Import_in_progress", user_id: userId } }),
    ]);

    const total = await prisma.products.count({ where: whereClause });

    const products = await prisma.products.findMany({
      where: whereClause,
      orderBy: { created_at: "desc" },
      select: {
        product_id: true,
        title: true,
        status: true,
        description: true,
        created_at: true,
      },
    });

    return json({
      counts: {
        all,
        readyToImport,
        imported,
        importInProgress,
      }
    });
  } catch (error) {
    console.error("Count API Error:", error);
    return json({ error: error.message }, { status: 500 });
  }
};
