import prisma from "../db.server";
import { json } from "@remix-run/node";
import { authenticate } from "../shopify.server";
import fs from "fs";
import path from "path";
import sgMail from "@sendgrid/mail";
export const loader = async ({ request }) => {
  try {
    console.log(request);
    const url = new URL(request.url);
    const userId = parseInt(url.searchParams.get("user_id"), 10);
    const productIds = url.searchParams
      .get("product_id")
      ?.split(",")
      .map((id) => parseInt(id.trim(), 10))
      .filter((id) => !isNaN(id));
    if (isNaN(userId)) {
      return json({ error: "Invalid product for Import" }, { status: 202 });
    }
    const userData = await prisma.users.findUnique({
      where: {
        id: userId,
      },
    });
    if (!(await userValidate(userData, productIds.length))) {
      return json(
        {
          msg: "You have reached your import limit. Please upgrade your plan to import more products.",
        },
        { status: 210 },
      );
    }
    for (const productId of productIds) {
      const product = await prisma.products.findFirst({
        where: {
          product_id: productId,
          user_id: userId,
        },
        select: {
          title: true,
          has_variation: true,
          status: true,
          etsylistingid: true,
          block: true,
          option1name: true,
          option2name: true,
          option3name: true,
          variation_image_mapping: true,
          product_type: true,
          brand: true,
          tags: true,
          description: true,
          product_image_data: true,
        },
      });
      // Fetch product variants separately
      const product_variants = await prisma.product_variants.findMany({
        where: {
          product_id: productId,
          user_id: userId,
        },
      });
      if (!product) {
        return json({ msg: "Product not found." }, { status: 202 });
      }
      // single variant
      if (product.option1name == "") {
        const { admin } = await authenticate.admin(request);

        const queryProduct = `
            mutation CreateProduct($product: ProductCreateInput!,$media:[CreateMediaInput!]) {
                productCreate(product: $product,media:$media) {
                    product {
                    id
                    title
                    variants(first: 10) {
                    nodes {
                            id
                            barcode
                            inventoryItem {
                                id
                            
                            }
                        }
                    }
                    options {
                        id
                        name
                        position
                        optionValues {
                        id
                        name
                        hasVariants
                        }
                    }
                    }
                    userErrors {
                    field
                    message
                    }
                }
                }`;
        let status = "ACTIVE";

        // let productImages = JSON.parse(product.product_image_data);
        let productImages = await prisma.pc_images.findMany({
          where: {
            user_id: userId,
            product_id: product_variants[0].asin,
          },
        });
        const media = productImages.map((img) => ({
          mediaContentType: "IMAGE",
          originalSource: img.imgurl.trim(),
        }));
        const maim_image =
          productImages.length > 0 ? productImages[0].imgurl : "";

          let description = product.description;
        let variables = {
          product: {
            title: product.title+" newwwwwwwwww",
            productType: product.product_type,
            descriptionHtml: description,
            tags: product.tags,
            vendor: product.brand,
            status: status,
            // publishedAt: new Date().toISOString()
          },
          media: media,
        };
        const response = await admin.graphql(queryProduct, { variables });
        const data = await response.json();
        if (data?.data?.productCreate?.product?.variants?.nodes?.[0]?.id) {
          const ProductVariant = product_variants;
          const shopifyProductId = data.data.productCreate.product.id;
          if (shopifyProductId) {
            const setting = await prisma.setting.findFirst({
              where: { user_id: userId },
            });
            let publicationId = setting?.shopify_publication_id;
            if (!publicationId) {
              const getPublicationsQuery = `
                        query {
                            publications(first: 5) {
                            edges {
                                node {
                                id
                                name
                                }
                            }
                            }
                        }`;

              const pubRes = await admin.graphql(getPublicationsQuery);
              const pubData = await pubRes.json();

              const onlineStorePublication =
                pubData.data.publications.edges.find(
                  (edge) => edge.node.name === "Online Store",
                );
              if (!onlineStorePublication) {
                console.error("Online Store publication not found");
                return;
              }
              publicationId = onlineStorePublication.node.id;
              // Step 3: Save publicationId in DB for future use
              if (setting) {
                await prisma.setting.update({
                  where: { id: setting.id },
                  data: { shopify_publication_id: publicationId },
                });
              }
            }
            // Step 4: Publish product
            const publishProductMutation = `
                        mutation PublishProduct($id: ID!, $input: [PublicationInput!]!) {
                        publishablePublish(id: $id, input: $input) {
                            userErrors {
                            field
                            message
                            }
                        }
                        }`;
            const publishResponse = await admin.graphql(
              publishProductMutation,
              {
                variables: {
                  id: shopifyProductId,
                  input: [{ publicationId }],
                },
              },
            );
            const publishResult = await publishResponse.json();
            if (publishResult.data.publishablePublish.userErrors.length > 0) {
              console.error(
                "Publish Errors:",
                publishResult.data.publishablePublish.userErrors,
              );
            } else {
              console.log(" Product published to Online Store");
            }
          }

          console.log(
            "Variant ID:",
            data.data.productCreate.product.variants.nodes[0].id,
          );
          const ProductVariantId =
            data.data.productCreate.product.variants.nodes[0].id;
          const weightUnit = convertWeightUnit(
            ProductVariant[0]["weight_unit"],
          );
          const weight = ProductVariant[0]["weight"] ?? 0;
          const sku = ProductVariant[0]["sku"] ?? "";
          let price = ProductVariant[0]["price"];
          if (userId == 1217) {
            let priceminus = price * 0.03;
            let newprice = price - priceminus;
            price = newprice;

          }
          const quantity = ProductVariant[0]["quantity"];
          const queryVariant = `
                mutation productVariantsBulkUpdate($productId: ID!, $variants: [ProductVariantsBulkInput!]!) {
                    productVariantsBulkUpdate(productId: $productId, variants: $variants) {
                        product {
                            id
                        }
                        productVariants {
                            id
                            inventoryItem{
                                id
                                inventoryLevels(first:1){
                                nodes{
                                    location{
                                    id
                                    }
                                }
                                }
                            }
                        }
                        userErrors {
                        field
                        message
                        }
                    }
                    }`;
          let variables = {
            productId: shopifyProductId,
            variants: [
              {
                id: ProductVariantId,
                inventoryItem: {
                  measurement: {
                    weight: {
                      unit: weightUnit,
                      value: parseFloat(weight),
                    },
                  },
                  requiresShipping: true,
                  sku: sku,
                  tracked: true,
                },
                inventoryPolicy: "DENY",
                price: price,
                taxable: true,
              },
            ],
          };
          const responseVariant = await admin.graphql(queryVariant, {
            variables,
          });
          const dataVariant = await responseVariant.json();
          const inventoryId =
            dataVariant.data.productVariantsBulkUpdate.productVariants[0]
              .inventoryItem.id;
          const locationId =
            dataVariant.data.productVariantsBulkUpdate.productVariants[0]
              .inventoryItem.inventoryLevels.nodes[0].location.id;
          const queryInventory = `
                    mutation InventorySet($input: InventorySetQuantitiesInput!) {
                        inventorySetQuantities(input: $input) {
                            inventoryAdjustmentGroup {
                            createdAt
                            reason
                            referenceDocumentUri
                            changes {
                                name
                                delta
                            }
                            }
                            userErrors {
                            field
                            message
                            }
                        }
                        }`;
          variables = {
            input: {
              ignoreCompareQuantity: true,
              name: "available",
              reason: "correction",
              quantities: [
                {
                  inventoryItemId: inventoryId,
                  locationId: locationId,
                  quantity: quantity,
                },
              ],
            },
          };
          const responseInventory = await admin.graphql(queryInventory, {
            variables,
          });
          const dataInventory = await responseInventory.json();
          console.log("Inventory Set Result:", dataInventory);
          writeLog("Inventory Set Result: " + JSON.stringify(dataInventory));
          writeLog(
            "error in inventory set: " +
              JSON.stringify(
                dataInventory?.data?.inventorySetQuantities?.userErrors.length,
              ),
          );
          if (
            dataInventory?.data?.inventorySetQuantities?.userErrors.length == 0
          ) {
            const imageInsert = [{ node: { id: "", url: maim_image } }];
            const insertProduct = await prisma.sh_products.create({
              data: {
                title: product.title,
                etsylistingid: String(product.etsylistingid),
                image: JSON.stringify(imageInsert),
                status: "linked",
                has_variation: product.has_variation,
                user_id: userId,
                shopify_product_id: shopifyProductId.replace(
                  "gid://shopify/Product/",
                  "",
                ),
                created_at: new Date(),
                updated_at: new Date(),
              },
            });
            writeLog("insertProduct  " + JSON.stringify(insertProduct));
            const insertVariant = await prisma.sh_product_variants.create({
              data: {
                sh_product_id: insertProduct.id,
                etsyproductid: ProductVariant[0].etsy_product_id
                  ? String(ProductVariant[0].etsy_product_id)
                  : "",
                quantity: parseInt(quantity),
                sku: String(sku),
                price: parseFloat(price),
                shopify_product_id: shopifyProductId.replace(
                  "gid://shopify/Product/",
                  "",
                ),
                shopify_variant_id: ProductVariantId.replace(
                  "gid://shopify/ProductVariant/",
                  "",
                ),
                shopify_inventory_item_id: inventoryId.replace(
                  "gid://shopify/InventoryItem/",
                  "",
                ),
                status: "linked",
                user_id: userId,
                created_at: new Date(),
                updated_at: new Date(),
              },
            });

            writeLog("insertVariant  " + JSON.stringify(insertVariant));
            const updateProduct = await prisma.products.update({
              where: {
                product_id_user_id: {
                  product_id: productId,
                  user_id: userId,
                },
              },
              data: {
                status: "Imported",
                shopifyproductid: shopifyProductId.replace(
                  "gid://shopify/Product/",
                  "",
                ),
              },
            });
            const updateVariant = await prisma.product_variants.update({
              where: {
                id_user_id: {
                  id: ProductVariant[0].id,
                  user_id: userId,
                },
              },
              data: {
                status: "Imported",
                shopifyproductid: shopifyProductId.replace(
                  "gid://shopify/Product/",
                  "",
                ),
                shopifyvariantid: ProductVariantId.replace(
                  "gid://shopify/ProductVariant/",
                  "",
                ),
                shopifyinventoryid: inventoryId.replace(
                  "gid://shopify/InventoryItem/",
                  "",
                ),
                shopifylocationid: locationId.replace(
                  "gid://shopify/Location/",
                  "",
                ),
              },
            });
          }

          // return json({ msg: "Product has been Import." ,shopifyproductid:shopifyProductId.replace("gid://shopify/Product/", "")}, { status: 202 });
        }
      } else {
        // let variation_image_mapping = JSON.parse(product.variation_image_mapping);
        // product_variants already fetched separately above
        let option1Name = product.option1name;
        let option2Name = product.option2name;
        console.log("option2Name ", option2Name);
        let variantNew;
        let productOption = [];
        let firstVariant;
        let count = 0;
        let option1 = [];
        let option2 = [];
        let variantVariables = [];
        let updateDatabase = [];
        let variantMedia = [];
        let firstImage = "";

        for (const variant of product_variants) {
          writeLog("variant " + JSON.stringify(variant));
          let variantOption = [];
          const weightUnit = convertWeightUnit(variant.weight_unit);
          const weight = variant.weight ?? 0;
          const sku = variant.sku ?? "";
          let price = variant.price;
          if (userId == 1217) {
            let priceminus = price * 0.03;
            let newprice = price - priceminus;
            price = newprice;
          }
          const quantity = variant.quantity;
          const barcode = variant.barcode;
          let variantImageId = "";
          let variantImage = "";
          count++;
          if (variant.option1val) {
            option1.push({ name: variant.option1val });
            variantOption.push({
              name: variant.option1val,
              optionName: option1Name,
            });
          }
          if (variant.option2val) {
            option2.push({ name: variant.option2val });
            variantOption.push({
              name: variant.option2val,
              optionName: option2Name,
            });
          }
          if (count == 1) {
            firstVariant = variant;
            if (variant.imageId !== null && variant.imageId !== "") {
              const image = await prisma.product_images.findFirst({
                where: {
                  user_id: userId,
                  etsylistinging_id: variant.imageId,
                },
              });
              firstImage = image.imgurl;
            }
          } else {
            if (variant.imageId !== null && variant.imageId !== "") {
              writeLog("imageId ");

              const image = await prisma.product_images.findFirst({
                where: {
                  user_id: userId,
                  etsylistinging_id: variant.imageId,
                },
              });
              writeLog(JSON.stringify(image));
              variantMedia.push({
                mediaContentType: "IMAGE",
                originalSource: image.imgurl,
              });
              variantNew = {
                optionValues: variantOption,
                price: price,
                inventoryQuantities: {
                  availableQuantity: quantity,
                  locationId: "",
                },
                barcode: barcode,
                inventoryItem: {
                  measurement: {
                    weight: {
                      unit: weightUnit,
                      value: parseFloat(weight),
                    },
                  },
                  requiresShipping: true,
                  sku: sku,
                  tracked: true,
                },
                inventoryPolicy: "DENY",
                mediaSrc: image.imgurl,
              };
            } else {
              variantNew = {
                optionValues: variantOption,
                price: price,
                inventoryQuantities: {
                  availableQuantity: quantity,
                  locationId: "",
                },
                barcode: barcode,
                inventoryItem: {
                  measurement: {
                    weight: {
                      unit: weightUnit,
                      value: parseFloat(weight),
                    },
                  },
                  requiresShipping: true,
                  sku: sku,
                  tracked: true,
                },
                inventoryPolicy: "DENY",
              };
            }
            variantVariables.push(variantNew);
          }
        }
        if (option2Name !== undefined && option2Name !== "") {
          const uniqueOptions1 = [];
          const uniqueOptions2 = [];

          const nameSet1 = new Set();
          const nameSet2 = new Set();

          for (const opt of option1) {
            if (!nameSet1.has(opt.name)) {
              nameSet1.add(opt.name);
              uniqueOptions1.push({ name: opt.name });
            }
          }
          for (const opt of option2) {
            if (!nameSet1.has(opt.name)) {
              nameSet1.add(opt.name);
              uniqueOptions2.push({ name: opt.name });
            }
          }

          productOption.push({ name: option1Name, values: uniqueOptions1 });
          productOption.push({ name: option2Name, values: uniqueOptions2 });
        } else {
          const uniqueOptions1 = [];

          const nameSet1 = new Set();

          for (const opt of option1) {
            if (!nameSet1.has(opt.name)) {
              nameSet1.add(opt.name);
              uniqueOptions1.push({ name: opt.name });
            }
          }
          productOption.push({ name: option1Name, values: uniqueOptions1 });
        }
        const { admin } = await authenticate.admin(request);
        const queryProduct = `
            mutation CreateProduct($product: ProductCreateInput!,$media:[CreateMediaInput!]) {
                productCreate(product: $product,media:$media) {
                    product {
                    id
                    title
                    variants(first: 10) {
                    nodes {
                            id
                            barcode
                            inventoryItem {
                                id
                            
                            }
                        }
                    }
                    options {
                        id
                        name
                        position
                        optionValues {
                        id
                        name
                        hasVariants
                        }
                    }
                    }
                    userErrors {
                    field
                    message
                    }
                }
                }`;
        let status = "ACTIVE";
        let productImages = await prisma.product_images.findMany({
          where: {
            user_id: userId,
            product_id: productId,
          },
        });
         const maim_image =
          productImages.length > 0 ? productImages[0].imgurl : "";
        const media = productImages.map((img) => ({
          mediaContentType: "IMAGE",
          originalSource: img.imgurl.trim(),
        }));
          let description = product.description;
          description = description;
        let variables = {
          product: {
            title: product.title,
            productType: product.product_type,
            descriptionHtml: description,
            tags: product.tags,
            vendor: product.brand,
            status: status,
            productOptions: productOption,
            // publishedAt: new Date().toISOString()
          },
          media: media,
        };

        const response = await admin.graphql(queryProduct, { variables });
        const data = await response.json();
        if (data?.data?.productCreate?.product?.variants?.nodes?.[0]?.id) {
          const shopifyProductId = data.data.productCreate.product.id;
          if (shopifyProductId) {
            const setting = await prisma.setting.findFirst({
              where: { user_id: userId },
            });

            let publicationId = setting?.shopify_publication_id;

            if (!publicationId) {
              const getPublicationsQuery = `
                        query {
                            publications(first: 5) {
                            edges {
                                node {
                                id
                                name
                                }
                            }
                            }
                        }`;

              const pubRes = await admin.graphql(getPublicationsQuery);
              const pubData = await pubRes.json();

              const onlineStorePublication =
                pubData.data.publications.edges.find(
                  (edge) => edge.node.name === "Online Store",
                );

              if (!onlineStorePublication) {
                console.error(" Online Store publication not found");
                return;
              }

              publicationId = onlineStorePublication.node.id;

              // Step 3: Save publicationId in DB for future use
              if (setting) {
                await prisma.setting.update({
                  where: { id: setting.id },
                  data: { shopify_publication_id: publicationId },
                });
              }
            }

            // Step 4: Publish product
            const publishProductMutation = `
                        mutation PublishProduct($id: ID!, $input: [PublicationInput!]!) {
                        publishablePublish(id: $id, input: $input) {
                            userErrors {
                            field
                            message
                            }
                        }
                        }`;

            const publishResponse = await admin.graphql(
              publishProductMutation,
              {
                variables: {
                  id: shopifyProductId,
                  input: [{ publicationId }],
                },
              },
            );

            const publishResult = await publishResponse.json();

            if (publishResult.data.publishablePublish.userErrors.length > 0) {
              console.error(
                "Publish Errors:",
                publishResult.data.publishablePublish.userErrors,
              );
            } else {
              console.log(" Product published to Online Store");
            }
          }
          console.log(
            "Variant ID:",
            data.data.productCreate.product.variants.nodes[0].id,
          );
          const ProductVariantId =
            data.data.productCreate.product.variants.nodes[0].id;
          const updateProduct = await prisma.products.update({
            where: {
              product_id_user_id: {
                product_id: productId,
                user_id: userId,
              },
            },
            data: {
              status: "Imported",
              shopifyproductid: shopifyProductId.replace(
                "gid://shopify/Product/",
                "",
              ),
            },
          });
          writeLog("updateProduct " + JSON.stringify(updateProduct));
            const imageInsert = [{ node: { id: "", url: maim_image } }];

            const insertProduct = await prisma.sh_products.create({
              data: {
                title: product.title,
                etsylistingid: String(product.etsylistingid),
                image: JSON.stringify(imageInsert),
                status: "linked",
                has_variation: product.has_variation,
                user_id: userId,
                shopify_product_id: shopifyProductId.replace(
                  "gid://shopify/Product/",
                  "",
                ),
                created_at: new Date(),
                updated_at: new Date(),
              },
            });
          writeLog("insertProduct  " + JSON.stringify(insertProduct));
          const sh_product_id = insertProduct.id;

          
          const weightUnit = convertWeightUnit(firstVariant.weight_unit);
          const weight = firstVariant.weight ?? 0;
          const sku = firstVariant.sku ?? "";
          const price = firstVariant.price;
          const quantity = firstVariant.quantity;
          const barcode = firstVariant.barcode;
          // now update default variant data
          const queryVariant = `
                    mutation productVariantsBulkUpdate($media:[CreateMediaInput!],$productId: ID!, $variants: [ProductVariantsBulkInput!]!) {
                        productVariantsBulkUpdate(media: $media,productId: $productId, variants: $variants) {
                            product {
                                id
                            }
                            productVariants {
                                id
                                inventoryItem{
                                    id
                                    inventoryLevels(first:1){
                                    nodes{
                                        location{
                                          id
                                        }
                                    }
                                    }
                                }
                            }
                          
                            userErrors {
                            field
                            message
                            }
                        }
                        }`;

          if (firstImage !== "") {
            variables = {
              media: [
                { mediaContentType: "IMAGE", originalSource: firstImage },
              ],
              productId: shopifyProductId,
              variants: [
                {
                  id: ProductVariantId,
                  inventoryItem: {
                    measurement: {
                      weight: {
                        unit: weightUnit,
                        value: parseFloat(weight),
                      },
                    },
                    requiresShipping: true,
                    sku: sku,
                    tracked: true,
                  },
                  inventoryPolicy: "DENY",
                  price: price,
                  taxable: true,
                  mediaSrc: firstImage,
                },
              ],
            };
          } else {
            variables = {
              productId: shopifyProductId,
              variants: [
                {
                  id: ProductVariantId,
                  inventoryItem: {
                    measurement: {
                      weight: {
                        unit: weightUnit,
                        value: parseFloat(weight),
                      },
                    },
                    requiresShipping: true,
                    sku: sku,
                    tracked: true,
                  },
                  inventoryPolicy: "DENY",
                  price: price,
                  taxable: true,
                },
              ],
            };
          }
          const responseVariantUpdate = await admin.graphql(queryVariant, {
            variables,
          });
          const dataVariant = await responseVariantUpdate.json();
          
          const inventoryId =
          dataVariant.data.productVariantsBulkUpdate.productVariants[0]
          .inventoryItem.id;
          const insertVariant = await prisma.sh_product_variants.create({
              data: {
                title: firstVariant.option2val ? firstVariant.option1val + " / " + firstVariant.option2val  : firstVariant.option1val,
                sh_product_id: insertProduct.id,
                etsyproductid: firstVariant.etsy_product_id
                  ? String(firstVariant.etsy_product_id)
                  : "",
                quantity: parseInt(quantity),
                sku: String(sku),
                price: parseFloat(price),
                shopify_product_id: shopifyProductId.replace(
                  "gid://shopify/Product/",
                  "",
                ),
                shopify_variant_id: ProductVariantId.replace(
                  "gid://shopify/ProductVariant/",
                  "",
                ),
                shopify_inventory_item_id: inventoryId.replace(
                  "gid://shopify/InventoryItem/",
                  "",
                ),
                status: "linked",
                option1:firstVariant.option1val,
                option2:firstVariant.option2val,
                user_id: userId,
                created_at: new Date(),
                updated_at: new Date(),
              },
            });
          const locationId =
            dataVariant.data.productVariantsBulkUpdate.productVariants[0]
              .inventoryItem.inventoryLevels.nodes[0].location.id;
          const updatedVariants = variantVariables.map((variant) => ({
            ...variant,
            inventoryQuantities: {
              ...variant.inventoryQuantities,
              locationId: locationId,
            },
          }));
          const queryInventory = `
                mutation InventorySet($input: InventorySetQuantitiesInput!) {
                    inventorySetQuantities(input: $input) {
                        inventoryAdjustmentGroup {
                        createdAt
                        reason
                        referenceDocumentUri
                        changes {
                            name
                            delta
                        }
                        }
                        userErrors {
                        field
                        message
                        }
                    }
                    }`;

          variables = {
            input: {
              ignoreCompareQuantity: true,
              name: "available",
              reason: "correction",
              quantities: [
                {
                  inventoryItemId: inventoryId,
                  locationId: locationId,
                  quantity: quantity,
                },
              ],
            },
          };

          const updateVariant = await prisma.product_variants.update({
            where: {
              id_user_id: {
                id: firstVariant.id,
                user_id: userId,
              },
            },
            data: {
              status: "Imported",
              shopifyproductid: shopifyProductId.replace(
                "gid://shopify/Product/",
                "",
              ),
              shopifyvariantid: ProductVariantId.replace(
                "gid://shopify/ProductVariant/",
                "",
              ),
              shopifyinventoryid: inventoryId.replace(
                "gid://shopify/InventoryItem/",
                "",
              ),
              shopifylocationid: locationId.replace(
                "gid://shopify/Location/",
                "",
              ),
            },
          });

          const responseInventory = await admin.graphql(queryInventory, {
            variables,
          });
          const dataInventory = await responseInventory.json();

          // now create other variants
          const queryVariantCreate = `
                mutation ProductVariantsCreate($media: [CreateMediaInput!],$productId: ID!, $variants: [ProductVariantsBulkInput!]!) {
                    productVariantsBulkCreate(media: $media,productId: $productId, variants: $variants) {
                        productVariants {
                        id
                         inventoryItem{
                            id
                            inventoryLevels(first:1){
                                nodes{
                                    location{
                                        id
                                    }
                                }
                            }
                        }
                        selectedOptions {
                                name
                                value
                            }
                        }
                        userErrors {
                            field
                            message
                        }
                    }
                    }
                `;
          if (
            variantMedia.length > 0 &&
            variantMedia[0].originalSource != null
          ) {
            variables = {
              media: variantMedia,
              productId: shopifyProductId,
              variants: updatedVariants,
            };
          } else {
            variables = {
              productId: shopifyProductId,
              variants: updatedVariants,
            };
          }
          writeLog("updatevarinat "+JSON.stringify(updatedVariants));
          const responseVariant = await admin.graphql(queryVariantCreate, {
            variables,
          });
          const dataVariantCreate = await responseVariant.json();
          writeLog(JSON.stringify(dataVariantCreate));
          for (const createdVariant of dataVariantCreate.data
            .productVariantsBulkCreate.productVariants) {
            let option1val = "";
            let option2val = "";

            if (
              createdVariant?.selectedOptions &&
              createdVariant.selectedOptions.length > 0 &&
              createdVariant.selectedOptions[0]?.value
            ) {
              option1val = createdVariant.selectedOptions[0].value;
            }

            if (
              createdVariant?.selectedOptions &&
              createdVariant.selectedOptions.length > 0 &&
              createdVariant.selectedOptions[1]?.value
            ) {
              option2val = createdVariant.selectedOptions[1].value;
            }
            writeLog("product_variants "+ JSON.stringify(product_variants));
            let etsy_product_id = await getEtsyProductId(product_variants,option1val,option2val );
            const insertVariant = await prisma.sh_product_variants.create({
              data: {
                title: option2val ? option1val + " / " + option2val  : option1val,
                sh_product_id: insertProduct.id,
                etsyproductid: etsy_product_id ? String(etsy_product_id) : "",
                quantity: parseInt(quantity),
                sku: String(sku),
                price: parseFloat(price),
                shopify_product_id: shopifyProductId.replace(
                  "gid://shopify/Product/",
                  "",
                ),
                shopify_variant_id: createdVariant.id.replace(
                  "gid://shopify/ProductVariant/",
                  "",
                ),
                shopify_inventory_item_id: createdVariant.inventoryItem.id.replace(
                  "gid://shopify/InventoryItem/",
                  "",
                ),
                status: "linked",
                user_id: userId,
                option1:option1val,
                option2:option2val,
                created_at: new Date(),
                updated_at: new Date(),
              },
            });
            await prisma.product_variants.updateMany({
              where: {
                option1val: option1val,
                option2val: option2val,
                product_id: productId,
                user_id: userId,
              },
              data: {
                status: "Imported",
                shopifyproductid: shopifyProductId.replace(
                  "gid://shopify/Product/",
                  "",
                ),
                shopifyvariantid: createdVariant.id.replace(
                  "gid://shopify/ProductVariant/",
                  "",
                ),
                shopifyinventoryid: createdVariant.inventoryItem.id.replace(
                  "gid://shopify/InventoryItem/",
                  "",
                ),
                shopifylocationid: locationId.replace(
                  "gid://shopify/Location/",
                  "",
                ),
              },
            });
          }
          // return json({ msg: "Product has been Import." ,shopifyproductid:shopifyProductId.replace("gid://shopify/Product/", "")}, { status: 202 });
        }
        // return {data}
      }
      const importedProductCount = await prisma.products.count({
        where: {
          user_id: userId,
          status: "Imported",
        },
      });
      if (importedProductCount === 1) {
        await sendEmail(userId);
      }
    }
    const getShopifyProductIds = await prisma.products.findMany({
      where: {
        user_id: userId,
        product_id: {
          in: productIds,
        },
      },
      select: {
        product_id: true,
        shopifyproductid: true,
      },
    });
    const user = await prisma.users.findUnique({
      where: {
        id: userId,
      },
    });
    return json(
      {
        msg: "Product has been Import.",
        getShopifyProductIds: getShopifyProductIds,
        user: user,
      },
      { status: 202 },
    );
  } catch (error) {
    writeLog("Error in import to shopify: " + error.message);
    return json({ msg: "An error occurred during import." }, { status: 202 });
  }
};

async function sendEmail(userId) {
  // 1. Get user

  writeLog(` Preparing to send email to user ${userId}`);
  const firstProduct = await prisma.products.findFirst({
    where: { user_id: userId, status: "Imported" },
    select: { product_id: true, shopifyproductid: true },
  });

  const user = await prisma.users.findUnique({
    where: { id: userId },
    select: { ownername: true, email: true, shopurl: true },
  });

  if (!user?.email) {
    writeLog(`Skipping email for user ${userId} — no email address`);
    return false;
  }

  const shopName = user.shopurl.replace(".myshopify.com", "");

  const msg = {
    from: {
      email: "shopifyapps@infoshore.biz",
      name: "Pankaj from InfoshoreApps",
    },
    to: user.email,
    cc: [
      "pankajnarang81@gmail.com",
      "somay.infoshore@gmail.com",
      "madhu.infoshore@gmail.com",
    ],
    subject:
      "[Shopify App] Etsy Importer by Infoshore – First Product Imported Successfully",
    html: `
  <p>Dear ${user.ownername},</p>
 
  <p>🎉 Congratulations! Your first product has been successfully published to your Shopify store.</p>
 
  <p> You can chcek your products on your store  <a href="https://admin.shopify.com/store/${shopName}/products/${firstProduct.shopifyproductid}" target="_blank"> View Products</a> page.</p>
 
  <p>You’re currently on our free trial, which allows you to publish up to <strong>5 products</strong>.
  To continue importing and publishing more, please explore our
  <a href="https://admin.shopify.com/store/${shopName}/apps/etsy-importer/app/plan" target="_blank">Plans & Pricing</a> page.</p>
 
  <h3>🤝 We’re Here to Help</h3>
  <p>Need guidance? You can
    <a href="https://calendly.com/madhu-infoshore/30min" target="_blank">
      schedule a free 30-minute meeting
    </a> with our support team for personalized setup assistance.</p>
 
  <p>You can also <a href="https://direct.lc.chat/18704628/" target="_blank">start a live chat</a> anytime to get quick answers and learn more about the app.</p>
 
  <p>If you have any questions, simply reply to this email — we’ll be happy to help!</p>
 
  <p><strong>Best regards,</strong><br>
  Pankaj Narang<br>
  InfoShore Apps</p>
 
  <p>Skype: pankaj.narang</p>
    `,
  };

  try {
    sgMail.setApiKey(process.env.SENDGRID_API_KEY);
    await sgMail.send(msg);
    writeLog(` Email sent successfully to ${user.email}`);
    return true;
  } catch (err) {
    writeLog(` Error sending email: ${err.message}`);
    if (err.response) {
      writeLog(` SendGrid response: ${JSON.stringify(err.response.body)}`);
    }
    return false;
  }
}

function convertWeightUnit(weight) {
  switch (weight) {
    case "oz":
      return "OUNCES";
    case "g":
      return "GRAMS";
    case "kg":
      return "KILOGRAMS";
    case "lb":
      return "POUNDS";
    default:
      return "KILOGRAMS";
  }
}

async function userValidate(userData, countOfProduct) {
  console.log("user data userValidate    ", userData);
  if (userData.skuconsumed >= userData.skulimit) {
    console.log("return false");
    return false;
  }
  let newSkuconsumed = userData.skuconsumed + countOfProduct;
  await prisma.users.update({
    where: {
      id: userData.id,
    },
    data: {
      skuconsumed: newSkuconsumed,
    },
  });
  return true;
}

const logPath = path.join("appNew.log");
function writeLog(message) {
  const timestamp = new Date().toISOString();
  const log = `[${timestamp}] ${message}\n`;

  fs.appendFile(logPath, log, (err) => {
    if (err) console.error("Error writing to log:", err);
  });
}

function getEtsyProductId(variants,option1val, option2val) {
  const match = variants.find(
    v => v.option1val === option1val && v.option2val === option2val
  );
  return match ? match.etsy_product_id : null;
}

